/*  Copyright (C) 2001  Dobin Rutishauser                 anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
   02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "../common/config.h"
#include "../common/utils.h"

#include "configvars.h"
#include "clientsockets.h"

extern void usage(char *name);

char	configfile[]	=   "client.conf";
int	debuglevel;
char	servers[2048];
char	password[40];
int	authtype;	

int	scandelay		= 0;
int	porttimeout		= 10;
int	scantype			= 0;

int	my_ports			= 0;  /* all port/host packets */
struct _msg_request *ports;


/*
 * parse_host_arg
 *
 * decodes the host string and then add the struct ports
 *
 * server[] is like: "192.168.1.1-10", "chaos,unreal" or "192.168.1.0/24"
 * ports[] is like: "port", "port1,port2" or "port1-port2" or combined
*/

int parse_host_arg (char server[MAX_ARG_LEN], char ports[MAX_ARG_LEN])
{
char saved_ports[MAX_ARG_LEN];
char temp[MAX_ARG_LEN];
char *bla;
char *val;
int res;

	/* server ist a comma seperated list */
	if (strchr(server, ','))
	{
		bla=malloc(strlen(server));
		strcpy(bla, server);

		while (( val = strsep (&bla, ",")) != NULL) 
		{
			if(*val != '\0')
			{
				strcpy(saved_ports, ports);
				res = fill_in_ports (val, saved_ports);
			}
		}

		free(bla);
		return(res);
	}

	/* subnets ala "192.168.1-100.1-255" */
	if (strchr(server, '-'))
	{
		leet_subnet_scan(server, ports);
		return(1);
	}


	/* easy subnet scanning */
	if (strchr(server, '/'))
	{
		int a, b, c;
		char *tmp;
		char ip[MAX_ARG_LEN]="";

		tmp = malloc(strlen(server));
		tmp = strchr(server, '/');

		if(!strcmp(tmp, "/24")) {
			bzero(temp, strlen(temp));
			strncpy(temp, server, strlen(server) - strlen(tmp) - 1);
			temp[strlen(server) - strlen(tmp) - 1]='\0';

			for(c=1; c<254; c++) {
				strcpy(saved_ports, ports);
				sprintf(ip, "%s%i", temp, c);
				res = fill_in_ports(ip, saved_ports);
			}

			return(res);
		}	

		if(!strcmp(tmp, "/16")) {
			b=0; c=1;

			bzero(temp, sizeof(temp));
			strncpy(temp, server, strlen(server) - strlen(tmp) - 3);
			temp[strlen(server) - strlen(tmp) - 3]='\0';

			while(b <= 254) {
				sprintf(ip, "%s%i.%i", temp, b, c++);

				if(c>254) {
					b++;
					c=1;
				}
				strcpy(saved_ports, ports);
				res = fill_in_ports(ip, saved_ports);
			}

			return(res);
		}

		if(!strcmp(tmp, "/8")) {
			a=0; b=0; c=1;

			bzero(temp, sizeof(temp));
			strncpy(temp, server, strlen(server) - strlen(tmp) - 5);
			temp[strlen(server) - strlen(tmp) - 5]='\0';

			while(c <= 254) {
				sprintf(ip, "%s%i.%i.%i", temp, a, b, c);
				c++;

				if(c>254) {
					b++;
					c=1;
				}
				if(b>254) {
					a++;
					b=0;
				}
				strcpy(saved_ports, ports);
				res = fill_in_ports(ip, saved_ports);
			}

			return(res);
		}

		logprintf(LVL_ERROR, "Bad subnet mask: %s", tmp);
		return(0);
	}


	/* only one host to scan */
	res = fill_in_ports(server, ports);

return(res);
}


/* parse command line
 *
 * parameters:
 *   argc and argv, how main()
 *
 * return values: 
 *   1 on success, 0 if not
*/

int parse_command_line (int argc, char *argv[])
{
int ch;
int res = 0;
int f_ipfile=0, f_ports=0, f_hosts=0;
char arg_ipfile[MAX_ARG_LEN]="";
char arg_hosts[MAX_ARG_LEN]="";
char arg_ports[MAX_ARG_LEN]="";

	while ((ch = getopt(argc, argv, "b:p:i:t:m:s:h")) != -1)
	{

		switch(ch)
		{
			case 'p':
				strncpy(arg_ports, optarg, MAX_ARG_LEN);
				f_ports = 1;
				break;
				
			case 'i':
				strncpy(arg_ipfile, optarg, MAX_ARG_LEN);
				f_ipfile = 1;
				break;
				
			case 't':
				scandelay = atol(optarg);
				if(scandelay < 0) {
					logprintf(LVL_WARNING, "negativ scandelay. use 1 instand");
					scandelay = 1;
				}
				break;
				
			case 'm':
				porttimeout = atoi (optarg);
				if (porttimeout < 1) {
					logprintf(LVL_WARNING, "negativ port timeout. use 100 instand");
					porttimeout = 100;
				}

				if (porttimeout > 255) {
					logprintf(LVL_WARNING, "to high port timeout. use 100 instand");
					porttimeout = 100;
				}

				break;
				
			case 's':
				scantype = atoi(optarg);

				if(scantype < 0 || scantype > 5) {
					logprintf(LVL_WARNING, "Invalid scan type %i. Use 0 instand", scantype);
					scantype=0;
				}
				break;

			case 'h':
				usage("dscanc");
				exit(0);
				break;
	
			default:
				usage("dscanc");
				exit(0);
				break;
		}
	}

	if (f_ipfile == 0)
	{
		/* no host? damn idiot... */
		if (argc == optind) {
			logprintf(LVL_ERROR, "no host specified");
		} else {
			strncpy(arg_hosts, argv[argc-1], MAX_ARG_LEN); 
			f_hosts = 1;
		}

		/* no ports? sucka.. */
		if (f_ports == 0) {
			strcpy(arg_ports, "21,22,23,25,80,111,110");
			f_ports = 1;
		}
	}

	/* ipfile and other options */
	if ( (f_ports == 1 || f_hosts == 1) && f_ipfile == 1)
	{
		logprintf( LVL_ERROR, "u cant use a ipfile and other options");
	}

	/* check ip file */
	if (f_ipfile == 1)
	{
		res =  handle_ip_file(arg_ipfile);
		if (res < 1)
		{
			logprintf( LVL_ERROR, "no suck file: %s", optarg);
		}
	}

	/* check for ports and hosts args */
	if (f_hosts == 1 && f_ports == 1) {
		res = parse_host_arg(arg_hosts, arg_ports);
		if (res < 1)
		{
			logprintf( LVL_ERROR, "error on: %s or %s", arg_hosts, arg_ports);
		}
	}

return(1);
}
