/*  Copyright (C) 2001  Dobin Rutishauser                 anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "../common/config.h"
#include "../common/utils.h"
#include "../common/messages.h"
#include "../common/structs.h"
#include "../common/networking.h"

#include "clientconfig.h"
#include "clientsockets.h"


server_t		*serverlist; /* list of servers we can connect to */
int			servercount; /* number of servers */

/* this is for host_mod, coz is would be bad if we give an iplist as
   an arg to a recursiv function... */
char arg_ports[MAX_ARG_LEN];

/* ctrl-c flag - used in the select loop in make_connection() */
int ctrlc_flag = 0;



/*
 * ctrlc handler
 *
 * handels ctr-c request for aborting the select() loop
 *
*/

void ctrlc_handler(int p) {
	ctrlc_flag = 1;
}


/*
 * initalise_sockets()	
 *
 * initializes the sockets
*/

void initialise_sockets(void)
{
	int i;

	/* initialize one socket per server */
	for (i=0; i<servercount; i++)
		serverlist[i].sock = socket( AF_INET, SOCK_STREAM, 0 );
}


/*
 * shutdown_sockets()
 *
 * deinitializes the sockets
*/

void shutdown_sockets()
{
	int i;

	/* close and shutdown sockets */
	for (i=0; i<servercount; i++)
		if ( INVALID_SOCKET != serverlist[i].sock )
		{
			shutdown( serverlist[i].sock, 0 );
			close (serverlist[i].sock);
		}
}


/*
 * handle_connection()
 *
 * parameters:
 *
 * int		server		number of the server to handle
 *
 * receives a header and then calls evaluate_message
*/

void handle_connection (int server)
{
	struct _msg_response response;
	struct knot *cur_knot;
	int	res;
	
	/* if not connected do nothing */
	if (serverlist[server].sock == INVALID_SOCKET) return;

	/* recv ONE port */
	res = recv (serverlist[server].sock, &response, sizeof(response), 0);
	if (res == SOCKET_ERROR || res == 0)
	{
		shutdown( serverlist[server].sock, 0 );
		closesocket( serverlist[server].sock );
		serverlist[server].sock = INVALID_SOCKET;
		return;
	}

	/* if we received a port state then we need to check one port less */
	cur_knot = liste->head;
	while (cur_knot) {
/* HACK
		if ((!strcmp(response.ip, cur_knot->ports->ip) && response.port == cur_knot->ports->portnr )) {
*/
		if ((response.ip == cur_knot->ports->ip) && (response.port == cur_knot->ports->portnr )) {
			cur_knot->ports->status = response.portstate;
			serverlist[server].anzports--;
		}
		cur_knot = cur_knot->next;
	}

	/* if there are no ports left for this server */
	if (serverlist[server].anzports == 0)
	{
		/* close this socket */
		shutdown (serverlist[server].sock, 0);
		closesocket (serverlist[server].sock );

		/* mark as invalid */
		serverlist[server].sock = INVALID_SOCKET;
		return;
	}
}


/*
 * authorize 
 *
 * authorize to the server
 * 
 * parameters: the socket
 * return values: 1 when authentication is successfully
 *                0 on errors
 *
 * by Anthraxx, 19.07.2001
*/

int authorize(SOCKET sock, int pkt_count) {
msg_auth_request auth_request;
msg_auth_response auth_response;
int res;

	res = recv (sock, &auth_request, sizeof(auth_request), 0);
   	if (res == SOCKET_ERROR || res == INVALID_SOCKET) {
		return(0);
	}

	if (auth_request.authtype < 1) {
		logprintf (LVL_MESSAGE, "Server doesnt use authentication");
		return (1);
	}

	if (auth_request.authtype != authtype) {
		logprintf (LVL_WARNING, "Server need authentication nr %i", auth_request.authtype);
		return (0);
	}

	/* standard options */
	strncpy(auth_response.username, "root", strlen(auth_response.username));
	auth_response.pkt_count = pkt_count;
	auth_response.authtype = authtype;

	switch(authtype) {
		case 1:
		      strcpy(auth_response.password, password);
				break;

		case 2:
				strcpy(auth_response.password, (char *)(crypt(password, "dr")));
				break;
	
		case 3:
				strcpy(auth_response.password, (char *)(crypt(password, "$i$unitednf")));
				break;

		default: logprintf (LVL_WARNING, "Unknown authtype %i", authtype);
				 break;
	}

	res = send (sock, (char *)&auth_response, sizeof(auth_response), 0);
   	if (res == SOCKET_ERROR || res == INVALID_SOCKET) {
		return (0);
	}

	res = recv (sock, &auth_request, sizeof(auth_request), 0);
   	if (res == SOCKET_ERROR || res == INVALID_SOCKET) {
		return (0);
	}
	
	if (auth_request.flag == 1) {
		logprintf (LVL_MESSAGE, "Authentication successfully");
		return (1);
	} else {
		logprintf (LVL_WARNING, "Authentication failed!");
		return (0);
	}

return(0);
}


/*
 * make connection to the server
 *
 * connects to the server
 *
*/

int	make_connection(void)
{
	SOCKADDR_IN		laddress;
	int		connectedsockets = 0;	/* anz server */
	int		res, i;

	/* YABA! (Yet Another Bad Hack) */
	if (my_ports < servercount)
	{
			servercount = my_ports;
	}

	/* connect sockets */
	for (i=0; i<servercount; i++)
	{
		/* set address and port */
		laddress.sin_family	= AF_INET;
		laddress.sin_port	= htons((unsigned short)serverlist[i].port);
		laddress.sin_addr.s_addr = inet_addr( serverlist[i].name );

		/* connect */
		res = connect(serverlist[i].sock,(struct sockaddr*)&laddress,sizeof(SOCKADDR_IN));
		if ( res == SOCKET_ERROR )
		{
			logprintf( LVL_WARNING, "could not connect to server %s port %u: %s", serverlist[i].name, serverlist[i].port, strerror(errno) );
			shutdown( serverlist[i].sock, 0 );
			closesocket( serverlist[i].sock );
			serverlist[i].sock = INVALID_SOCKET;
			continue;
		}

		connectedsockets++;
	}

	/* if no socket was connected we cannot scan */
	if (!connectedsockets) {
		logprintf (LVL_CRITICAL, "could not establish any server connection");
	}

return(connectedsockets);
}	


/*
 * send_ports()
 *
 * send ports to scan to the servers
 *
*/

int send_ports(int connectedsockets) {
	int		ports_per_server = 0;
	int		uneven_flag = 0;
	int		res, n, i;
	struct 	_msg_request send_request;
	struct	knot *cur;

	/* here the problem:
	 * if my_ports % connectedosckets is more than 0, 
	 * my_ports doesn't get up with the servers.
	 * but we must distribute an equal number of ports to all servers!
	 * so we send the excessive number of ports to the first server, and
	 * then continue as if nothing was :)
	 *
	 * bad hack, yeah, but submit a better solution...
	 */ 
	if((my_ports % connectedsockets) != 0) {
		uneven_flag = (my_ports % connectedsockets);
	}


	logprintf( LVL_MESSAGE, "distributing %i ports to %u server(s)", my_ports, connectedsockets );


	/* send requests to the servers */
	for (i=0; i<servercount; i++)
	{
		ports_per_server = my_ports / connectedsockets;

		if (uneven_flag > 0) {
			ports_per_server+=uneven_flag;
		}

		if (serverlist[i].sock == INVALID_SOCKET) {
			continue;
		}
		

		/* authentication */
		res = authorize(serverlist[i].sock, ports_per_server);
	  	if(res == 0) {
			logprintf(LVL_WARNING, "could not connect to %i\n", serverlist[i].sock);
			serverlist[i].sock = INVALID_SOCKET;
			connectedsockets--;
			continue;
		}

		/* take ports_per_server ports and send it */
		while(ports_per_server > 0)
		{
			/* we need to randomly pick a port
			   i do this, by take a random number, witch is less than
            my_ports (number of all my ports), and then go n times 
				throught the structs. it's not very fast or effective, but 
				it does the job.
			*/

			cur=liste->head;
			do {
				n = (int)(rand()/1000000);
			} while (n >= my_ports || n < 0);

			for(; n>=1; n--) {
				cur = cur->next;
			}

			if(cur->ports->status != PORT_SENDED)
			{
				/* i don't want to send to fast, servers don't like it */
				usleep(10000);
				send_request = *cur->ports;

				res = send (serverlist[i].sock, (char*)&send_request, sizeof(send_request), 0);
				if (res == INVALID_SOCKET) {
					logprintf(LVL_WARNING, "send error to %i\n", serverlist[i].sock);
					serverlist[i].sock = INVALID_SOCKET;
					connectedsockets--;
					break;
				}
		
				cur->ports->status = PORT_SENDED;
				ports_per_server--;		
				
				/* update ports on a server */
				serverlist[i].anzports++;

			}
		}

		/* clean out the shit we maked with uneven */
		if (uneven_flag > 0) {
			ports_per_server-=uneven_flag;
			uneven_flag = 0;
		}	
	}

return(0);
}


/*
 * receive server answers
 *
 * receive the answers/scanned ports from the server
 *
*/

int recv_srv_answer(int connectedsockets) {
	int		res, i;
	fd_set	readfs;
	struct	timeval timeout;


	/** wait/recv the answers **/
	/* we go throught every socket and see wether we can read
      from it. if so, we do read a (one) packet.
   */
	FD_ZERO(&readfs);

	/* wait 1/2h for the answers. */
	/* if this time is up, a server is probably down */
	timeout.tv_sec = 1800;
	timeout.tv_usec = 0;

	ctrlc_flag = 0;
	signal(SIGINT, ctrlc_handler);

	while (connectedsockets > 0)
	{
		FD_ZERO(&readfs);
		for (i=0; i<servercount; i++)
		{
			if (serverlist[i].sock != INVALID_SOCKET)
			{
				FD_SET (serverlist[i].sock, &readfs);
			}
		}

		res = select(connectedsockets+5, &readfs, NULL, NULL, &timeout);
		if (res == 0) /* timeout */
		{
			connectedsockets = 0;
			break;
		}

		if (ctrlc_flag == 1)
		{
			printf("ctrl-c was pressed - skipping remaining ports !!\n");
			return(1);
		}

		if (res < 0)
		{
			logprintf (LVL_ERROR, "select error");
			connectedsockets = 0;
			break;
		}

		for (i=0; i<servercount; i++)
		{
			if (serverlist[i].sock != INVALID_SOCKET && FD_ISSET (serverlist[i].sock, &readfs))
			{
				handle_connection(i);

				if ( serverlist[i].sock == INVALID_SOCKET )
		   	{
					connectedsockets--;
				}
			}
		}
	}

return(0);
}


/* fill in ports
 *
 * takes a servername and a port string (like "21 22-50", or "21,22-50")
 * fill servernames with ports in the struct ports
 * 
 * return 1 on success, -1 on failure
 *
*/

int fill_in_ports (char server[MAX_ARG_LEN], char sports[MAX_ARG_LEN])
{
HOSTENT *he;
int b, e;
int nn;
char *val;
struct _msg_request *nport;

	he = gethostbyname (server);
	if (!he) {
		logprintf (LVL_CRITICAL, "could not resolve %s", server);
		return(0);
	}
	
	/* damn, strsep is very, very... strange */
	/* take me about an hour to figure out how this works, hehe */
	while ((val = strsep (&sports, ", \t")) != NULL)
	{
		if(*val != '\0')
		{
			/* check for port ranges */
			if (strchr (val, '-') != NULL)
			{
				b=atoi(strtok(val, "-"));
				e=atoi(strtok(NULL, "-"));

				if ( b < 1 || b > 65536 || e < 1 || e > 65535 ) {
					logprintf (LVL_ERROR, "port incorrect");
					free(val);
					return(0);
				}

				if (b > e) {
					logprintf (LVL_ERROR, "portrange error: %i is bigger than %i", e, b);
					free(val);
					return(0);
				}

				for (nn=b; nn<=e; nn++)
				{
					nport = malloc (sizeof (struct _msg_request));

					if (! nport) {
						logprintf (LVL_ERROR, "malloc failed!!");
						free(nport);
						return(0);
					}

					nport->ip = my_aton (he->h_name);
/* HACK
					strncpy(nport->ip, 
						inet_ntoa(*(struct in_addr*)he->h_addr_list[0]),
						sizeof(nport->ip));
*/

					nport->portnr = nn;
	
					nport->status = PORT_UNKNOWN;
					//nport->time = 0;
					nport->timeout = porttimeout;
					nport->delay = scandelay;
					nport->type = scantype;

					if (! list_insert(nport)) {
						free(nport);
						logprintf (LVL_ERROR, "could not insert port");
					}
					
					my_ports++;
				}
			} 
			else	/* no range, one port only */
			{
				if ( (atoi(val) < 1) || (atoi(val) > 65536) ) {
					logprintf (LVL_ERROR, "port incorrect");
					return(0);
				}

				nport = malloc (sizeof (struct _msg_request));
				if (!nport) {
					logprintf (LVL_ERROR, "malloc failed!!");
					free(nport);
					return(0);
				}

				nport->ip = my_aton (he->h_name);
/* HACK
				strcpy(nport->ip,
					inet_ntoa(*(struct in_addr*)he->h_addr_list[0]));
					nport->portnr = atoi(val);
*/
				
				nport->status = PORT_UNKNOWN;
				//nport->time = 0;
				nport->timeout = porttimeout;
				nport->delay = scandelay;
				nport->type = scantype;

				if (! list_insert(nport)) {
					free(nport);
					logprintf (LVL_ERROR, "could not insert port");
					return(0);
				}

				my_ports++;
			}
		}
	}

return(1);
}


/*
 * fill_server_list()
 *
 * fills the server_t array with the servers
 *
*/

void	fill_server_list(void)
{
	char	*p,*p2;
	int	i;
	HOSTENT	*he;

	servercount = 1;
	p = servers;
	
	while ( (p = strchr(++p, ',')) != NULL)
	{
		servercount++;
	}

	serverlist = malloc(servercount * sizeof(server_t));
	if (serverlist == NULL) {
		perror("malloc");
		exit(1);
	}
	
	p = servers;

	for (i = 0; i<servercount; i++)
	{
		p2 = strchr(p, ':');
		if (p2) { *p2 = 0; serverlist[i].port = atoi(p2+1); } else serverlist[i].port = 23555;

		if (p2)	p2 = strchr(p2+1, ','); else p2 = strchr(p, ',');
		if (p2) *p2 = 0;

		p = strtrm(p, " \n\t");

		p = strlwr((char *)p);
		he = gethostbyname( p );
		if (he)
			sprintf( serverlist[i].name, "%s", inet_ntoa(*(struct in_addr*)he->h_addr_list[0]) );
		else
		{
			if (!strcmp(p, "localhost"))
				strcpy (serverlist[i].name, "127.0.0.1");
			else
				strcpy (serverlist[i].name, "%s");
		}

		serverlist[i].sock = INVALID_SOCKET;
		serverlist[i].anzports = 0;
	
		p = p2+1;
	}
}


/* handle_ip_file
 *
 * takes a filename with ips + ports
 *
 * file design:
 * ip port port port ...
 * 192.168.1.1 80 23 22 25 ...
 *
 * Anthraxx, 21.07.2001
*/ 

int handle_ip_file(char *filename) 
{
FILE *fhd;
char line[MAX_ARG_LEN];
char sline[MAX_ARG_LEN];
char srv[MAX_ARG_LEN];
char *a, *p;
int linenum=0, res;

	fhd = fopen(filename, "r");
	if (!fhd) {
		logprintf (LVL_ERROR, "cannot open file %s", filename);
	}

	while (!feof(fhd))
	{
		linenum++;
		if (fgets (line, MAX_ARG_LEN, fhd)) {
			strncpy (sline, line, sizeof(sline)); /* hehe damn, strtok sucks!! */
		
			if(line[0] != '#') {
				a = strtok (line, " ");
				strncpy (srv, a, sizeof(srv)); /* copy the servername to srv */

				p = sline+1; /* first charachter is space */


				/* delete eol */
				if (! isprint (p[strlen (p)-1])) {
					p[strlen(p)-1]='\0';
				} 

				/* p point now to all our ports */
				p += strlen(a);

				res = parse_host_arg(srv, p);
				if (res < 0) {
					logprintf (LVL_CRITICAL, "can't assigne ports");
					exit(2);
				}
			}
		}
	}

	fclose(fhd);
return(1);	
}



/* host mod
 *
 * *muahahahahahahahahhhhhhaaaaaa* 
 * what a fight! what a battlefield! what a mess!! 
 * but it works, my first recursiv funktion! :) 
 *
 * this function takes an ip-arg like "192.168.1.1-100" and 
 * extracts + input the ip's
 *
 * done is the shit we have done, and work what is to do, like:
 * 192.168.1-20.1 is the ip range, and
 *   192.168. is done, and
 *   1-20.1 must be working on
*/

int host_mod (char done[MAX_ARG_LEN], char work[MAX_ARG_LEN])
{
char my_done[MAX_ARG_LEN];
char my_work[MAX_ARG_LEN];
char cp_done[MAX_ARG_LEN];
char cp_work[MAX_ARG_LEN];
char strsep_cp_work[MAX_ARG_LEN];
char *strsep_ptr;
char *cp_work_ptr;
char *cp_work_ptr2;
char *range_sep_ptr;

int a, b, i;

	strcpy(cp_done, done);
	strcpy(cp_work, work);

	strcpy(strsep_cp_work, work);
	cp_work_ptr = (char *)&strsep_cp_work;

	/* damn, strsep is as dumb as strstok.. */
	strsep_ptr = strsep(&cp_work_ptr, ".\t");

	/* strsep_ptr is void, if we are at the last run */
	if (cp_work_ptr == NULL) {
		strcpy(my_work, "");
	} else {
		strcpy(my_work, cp_work_ptr);
	}


	if (strchr (strsep_ptr, '-'))
	{
		cp_work_ptr2 = strsep_ptr;

		range_sep_ptr = strsep(&cp_work_ptr2, "-");
		a = atoi(range_sep_ptr);
		range_sep_ptr = strsep(&cp_work_ptr2, "-");
		b = atoi(range_sep_ptr);

		if (a < 0 || a > 254 || b < 0 || b > 254) {
			logprintf (LVL_ERROR, "ip error: %i or %i", a, b);
			return(0);
		}

		if (a > b) {
			logprintf (LVL_ERROR, "iprange error: %i is bigger than %i", a, b);
			return(0);
		}

		for(i=a; i<=b; i++) {
			strcpy(my_done, cp_done);

			if(cp_work_ptr == NULL) {
				sprintf(my_work, "%i", i);
			} else {
				sprintf(my_work, "%i.%s", i, cp_work_ptr);
			}

			if(strcmp (cp_work, "")) {
				host_mod(my_done, my_work);
			} else {
				return(1);
			}
		} 

	} else {
		/* is this the end? */
		if (strcmp (cp_work, ""))
		{
			if (! strcmp (cp_done, "")) {
				sprintf(my_done, "%s", strsep_ptr);
			} else {
				sprintf(my_done, "%s.%s", cp_done, strsep_ptr);
			}
			host_mod(my_done, my_work);
		} else {
			fill_in_ports(done, arg_ports);
			return(1);
		}
	}

return(0);
}


/* leet subnet scan
 *
 * this is a handler for host_mod, primary to copy the portarg
 * to the global variable.
 *
*/
int leet_subnet_scan(char server[MAX_ARG_LEN], char portarg[MAX_ARG_LEN])
{
	strcpy(arg_ports, portarg);
	host_mod("", server);

return(0);
}


/*
 * list show
 *
 * show the entire list in formatted output
 *
*/

void list_show(void)
{
struct list_head *hd = liste;
struct knot *cur=hd->head;
struct servent *sv;
char service[32];
char *ip;

	if(!cur)
		{
			printf("Die Liste ist leer!\n");
			return;
		}

	while(cur)
		{
			sv = getservbyport(htons(cur->ports->portnr), "tcp");
			bzero(service, sizeof(service));
         if (sv == 0) {
				strncpy(service, "???", 3);
         } else {
	         strncpy(service, sv->s_name, strlen(sv->s_name));
			}

			ip = my_ntoa(cur->ports->ip);

			if(cur->ports->status == PORT_OPEN) {
				printf("%s:     %5u (%s)\n", ip, cur->ports->portnr, 
					service);
			}
		
			if(cur->ports->status == PORT_FILTERED) {
				printf("%s:     %5u (%s)  (filtered)\n", ip, cur->ports->portnr, 
					service);
			}

			if(cur->ports->status == PORT_UNKNOWN) {
				printf("%s:     %5u (%s)  (unknown)\n", ip, cur->ports->portnr, 
					service);
			}
			cur=cur->next;
		}

}

