/*  Copyright (C) 2001  Dobin Rutishauser                 anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de

  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

    Free Software Foundation, Inc., 
    59 Temple Place, Suite 330, 
    Boston, MA
    02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>


/* client functions and variables for the client */
#include "clientsockets.h"
#include "clientconfig.h"

/* common variables, used by both, server and client */
#include "../common/messages.h"
#include "../common/config.h"
#include "../common/utils.h"
#include "../common/structs.h"


/*
 * usage()
 *
 * prints the program syntax on the screen
 * takes the program name as argument
*/

void	usage( char *name )
{
	printf("Usage: client [options] <-p port1,port2-port3> <hosts>\n\n" );
	printf("Options are:\n\n");
	printf("  -p          ports to scan\n");
	printf("  -i [file]   take an ipfile as input\n");
	printf("  -t xx       wait xx seconds between ports\n");
	printf("  -m xx       port timeout for stealthscans (in 1/10 seconds)\n");
	printf("  -s x        Scan Type\n");
	printf("     0        Connect Scan \n");
	printf("     1        SYN Scan \n");
	printf("     2        FIN Scan\n");
	printf("     3        XMAS Scan\n");
	/* printf("     4        NULL Scan\n"); */
	
	printf("  ports must be seperated throught commas (,), ranges (-) are allowed. \n");
	printf("  hosts must be seperated throught commas, and must be the last argument!\n");
	printf("   or you can give a subnet, like 192.168.1.0/24 (watch the 0!),\n");
	printf("   or a real subnet ala 192.168.1-10.1-200 (no * !) \n");
	printf("\n");
}


/*
 * main()
 *
 * standard main parameters
 * 
 * return values:
 * nonzero if scan was successful
 * zero if not
*/

int main(int argc, char *argv[])
{
long i;

	printf("Distributed Port Scanner Client Version %s - %s\n", DSCANVERSION, DSCANBUILDTIME);
	printf("Coded for U.N.F.: http://www.u-n-f.com\n\n");
	printf("Copyright (C) 2001 by Dobin Rutishauser && Bjrn Paetzel\n\n");

	if (argc==1)
	{
		usage (argv[0]);
		return (0);
	}

	/* create a new list */
	liste = list_create();
	if (! liste) {
      logprintf (LVL_ERROR, "could not create list");
	}

	srand(getpid());

	/* must be before parse_command_line */
	i = read_config_file (configfile);
	if (i < 0) {
		logprintf (LVL_ERROR, "could not read config file");
	}

	/* fill in the servers from the configfile */
	fill_server_list ();
	
	i = parse_command_line (argc, argv);
	if (i <= 0) {
		logprintf(LVL_ERROR, "Argument error!\n");
	}

	/* initialize sockets */
	initialise_sockets ();


	/* connect to the servers */
	i = make_connection();
	if (i <= 0) {
		logprintf(LVL_ERROR, "connection problems!\n");
	}

	/* send scan requests */
	send_ports(i);

	/* receive the results */
	recv_srv_answer(i);


	/* print the result */
	list_show();

	/* finish */
	shutdown_sockets();
	list_delall();

	printf("\n");
return(1);
}
