/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

// ---------------------------------------------------------- //
// config.h
//
// this file includes variables for both, the server and the client
// and the prototypes for config.c

#define	DSCANVERSION	"0.6.unix" 

#define DSCANBUILDTIME	__DATE__ " " __TIME__

#ifdef _SERVER
#include "../server/serverconfig.h"
#else
#include "../client/clientconfig.h"
#endif

/* maximal argument length */
#define MAX_ARG_LEN 128

// ---------------------------------------------------------- //
// types

#ifndef CONFIG_TYPES_DEFINED
#define CONFIG_TYPES_DEFINED

// config types

typedef enum _vartype
{
	vt_boolean,
	vt_int,
	vt_long,
	vt_float,
	vt_string
} vartype;

typedef	struct _config_s
{
	char	*name;
	vartype	type;
	void	*var;
	int		size;
	char	*defaultval;
} config_t;

#endif


extern config_t configvars[];

// ---------------------------------------------------------- //
// functions in config.c

int	find_variable_for_name (const char *name);
int	set_variable (int num, char *value);
void	parse_config_line (const char *line, int linenum);
void	set_default_config(void);
int	read_config_file (char *name);
