/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de

  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/


#include <sys/types.h>

// ---------------------------------------------------------- //
// socket defs

#define		SOCKET		int
#define		INVALID_SOCKET	-1
#define		SOCKET_ERROR	-1
#define		HOSTENT		struct hostent
#define		SOCKADDR	struct sockaddr
#define		SOCKADDR_IN	struct sockaddr_in

#define			closesocket(a) close(a)


// ---------------------------------------------------------- //
// port states

#define			PORT_CLOSED	0
#define			PORT_OPEN	1
#define			PORT_FILTERED	2
#define			PORT_UNFILTERED 4
#define			PORT_SENDED	8
#define			PORT_UNKNOWN	-1


// ---------------------------------------------------------- //
// message structs

#ifndef		MESSAGE_TYPES_DEFINED
#define		MESSAGE_TYPES_DEFINED

typedef struct _msg_auth_request
{
	unsigned short		authtype;
	unsigned short		flag;
} msg_auth_request;


typedef struct _msg_auth_response
{
	char	username[23];
	char	password[40];
	unsigned short	authtype;
	unsigned	int	pkt_count;
} msg_auth_response;


typedef struct _msg_request
{
	in_addr_t ip;
	unsigned int portnr;
	short status;

	unsigned short timeout;
	unsigned short delay;
	unsigned short type;
} msg_request;


typedef struct _msg_request
{
	in_addr_t ip;
	unsigned int portnr;
	
	unsigned short type;
	unsigned short delay;
	unsigned short timeout;


}


typedef struct _msg_response
{
	in_addr_t ip;
	unsigned int	port;
	short	portstate;
} msg_response;

#endif
