/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
	You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
   02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>

#include "structs.h"
#include "../common/utils.h"

/*
 * list insert
 *
 * inserts a struct in the list
 *
 * args are the _msg_request struct to input
 *
*/

int list_insert(struct _msg_request *new_port)
{
struct knot *ap;
struct list_head *hd = liste;

	ap = (struct knot *) malloc (sizeof (struct knot));

	if (ap == NULL) {
		logprintf(LVL_ERROR, "list insert malloc error");
	}

	if(ap)
		{
			ap->ports=new_port;
			ap->next=0;

			if(!(hd->head))
				{
					hd->head=hd->tail=ap;
					return(1);
				}
			else
				{
					hd->tail->next = ap;
					hd->tail=ap;
					return(1);
				}
		}
return(0);
}


/*
 * list delall
 *
 * delete's the entire list
 *
*/

void list_delall(void)
{
struct list_head *hd = liste;
struct knot *cur=hd->head, *nex;

	while(cur)
		{
			nex=cur->next;
			free(cur->ports);
			free(cur);
			cur=nex;
		}
	free(hd);
}


/*
 * list create
 *
 * creates a list
 *
*/

struct list_head *list_create(void)
{
struct list_head *head = (struct list_head *)malloc (sizeof (struct list_head));

	if(head)
	{
		head->head=head->tail=0;
		return(head);
	} else {
		logprintf(LVL_ERROR, "list head malloc error");
	}
	return(0);
}
