/*  Copyright (C) 2001    Dobin Rutishauser        dobin.rutishauser@gmx.net
                          Bjrn Paetzel                       kolrabi@gmx.de
	 
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <unistd.h>

#include "serversockets.h"
#include "serverconfig.h"

#include "../common/messages.h"
#include "../common/config.h"
#include "../common/utils.h"


/*
 * children handler
 *
 * let my children exits clearly
*/

void children_handler (int signo)
{
	pid_t pid;
	int status;

	while ((pid = waitpid(-1, &status, WNOHANG)) > 0)
	{
		logprintf( LVL_VERBOSE, "children %i exits", pid); 
	}

}


/*
 * main
 *
 * server main()
 * never exits clearly
*/

int main(int argc, char *argv[])
{
	printf("Distributed Port Scanner Server Version %s - %s\n", DSCANVERSION, DSCANBUILDTIME);
	printf("Coded for U.N.F.: http://www.u-n-f.com\n\n");
	printf("Copyright (C) 2001 by Dobin Rutishauser && Bjrn Paetzel\n\n");

	signal(SIGCHLD, children_handler);

	/* configure */
	read_config_file( configfile );

	/* initialize sockets */
	initialise_sockets();

	/* go to endless server loop */
	server_loop();

return(0);
}
