/*  Copyright (C) 2001   Dobin Rutishauser               anthraxx@gmx.net
                         Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include <sys/types.h>
#include <unistd.h>

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <libnet.h>
#include <pcap.h>

#include "../common/config.h"
#include "../common/utils.h"
#include "../common/messages.h"
#include "../common/structs.h"
#include "../common/networking.h"

#include "serverconfig.h"
#include "serversockets.h"
#include "scan.h"


/* we initialize both in the beginning @ initialise_sockets */
int			libnet_socket=0;
pcap_t		*libpcap_socket=NULL;
SOCKET		listensocket = INVALID_SOCKET; /* sux */


/*
 * initalise_sockets()
 *
 * initializes the server, libnet and libpcap  sockets
*/ 

int	initialise_sockets (void)
{
SOCKADDR_IN		laddress;

	/* initialise listening socket */
	listensocket = socket( PF_INET, SOCK_STREAM, 0 );

	if ( listensocket == INVALID_SOCKET) 
	{ 
		logprintf( LVL_CRITICAL, "could not create socket.." ); 
		return (0);
	}

	/* set local address and port */
	laddress.sin_family		= AF_INET;
	laddress.sin_port		= htons( listenport );
	laddress.sin_addr.s_addr	= INADDR_ANY;
	//inet_aton( bindaddress, &laddress.sin_addr );

	if ( SOCKET_ERROR == bind( listensocket, (SOCKADDR*)&laddress, sizeof(laddress)) )
	{
		logprintf( LVL_CRITICAL, "could not bind().." ); 
		return (0); 
	}

	/* start listening */
	if ( SOCKET_ERROR == listen( listensocket, 3 ) )
	{
		logprintf( LVL_CRITICAL, "could not start listening on port %u..", listenport ); 
		return (0);
	}

	logprintf( LVL_MESSAGE, "now listening on port %u..", listenport ); 


	/* initialise raw libnet and pcap sockets */

   /* initialize libnet */
   libnet_socket = libnet_open_raw_sock (IPPROTO_RAW);
   if (libnet_socket < 0)
   {
      libnet_error (LIBNET_ERR_FATAL, "Can't open network.\n");
      return (0);
   }
	

   /* initialize pcap - to_ms (20) is taken from nmap */
   if (strlen (localinterface) > 1) {
     libpcap_socket = pcap_open_live (pcap_lookupdev(localinterface), 1500, 0, 20, NULL);
   } else {
      libpcap_socket = pcap_open_live (pcap_lookupdev(NULL), 1500, 0, 20, NULL);
   }
   if (libpcap_socket == NULL)
   {
      perror ("pcap_open_live()");
      return (0);
   }

return(1);
}



/*
 * evaluate message
 *
 * scan the ports given by the client and send the result's back
 *
 * sock       is the socket which one we send the result back
 * pkt_count  the number of packets we scan
 *
*/

int	evaluate_message (SOCKET sock, int pkt_count)
{
	struct _msg_response response;
	int n;
	int res;
	struct knot *cur = liste->head;
	struct _infopacket infopacket;
	    	

	/* go throught every packet, scan that shit and then send the results back */
	for(n=0; n<pkt_count; n++) {
		sleep (cur->ports->delay);

// HACK		strncpy(response.ip, cur->ports->ip, sizeof(response.ip));
		response.ip = cur->ports->ip;
		response.port = cur->ports->portnr;

		if (! (infopacket.dst_ip = libnet_name_resolve(my_ntoa(cur->ports->ip), LIBNET_RESOLVE)))
		{
			libnet_error (LIBNET_ERR_FATAL, "Bad destination IP address: %s\n", cur->ports->ip);
		}
		infopacket.dst_port = cur->ports->portnr;
		infopacket.mode = cur->ports->type;
		infopacket.timeout = cur->ports->timeout;

//		printf("Scan: %s %i\n", my_ntoa(cur->ports->ip), infopacket.dst_port); fflush(stdout); 
		response.portstate = scan(&infopacket);

		/* send the result back */
		res = send (sock, (char*)&response, sizeof(response), 0 );
		if (res == SOCKET_ERROR)
		{
			printf("\n");
			logprintf( LVL_WARNING, "lost connection to client" );
			close(sock);
			exit(1);
		}

		cur = cur->next;
	}

	printf("\n");
return(0);
}


/*
 * send_auth_request 
 *
 * parameters: the socket for sending
 *             authtype and flag for the msg_auth_request packet
 * 
 * return values: 0 on errors, otherwise 1
 *
 * by Anthraxx, 19.07.2001
*/ 

int send_auth_request(SOCKET sock, int authtype, int flag )
{
msg_auth_request auth_request;
int res; 

	auth_request.authtype = authtype;
	auth_request.flag = flag;

	res = send(sock, (char *)&auth_request, sizeof(auth_request), 0);
	if ( res == SOCKET_ERROR || res == INVALID_SOCKET) {
		return(0);
	}

return(1);
}



/*
 * authorize()
 *
 * parameters: the socket for sending
 * return values: 1 if authorisation is successfull, 
 *                0 on errors or authorisation problems
 *
 * by Anthraxx, 19.07.2001
*/

int	authorize(SOCKET sock)
{
msg_auth_response auth_response;
int res;
int pkt_count=0;

	res = send_auth_request(sock, authtype, 0);
	if (res == 0) {
		logprintf( LVL_WARNING, "couldn't send auth request" );
		return (0);
	}

	if (authtype == 0) {
		logprintf (LVL_MESSAGE, "authentication is not used" );
		return(1);
	}

	res = recv(sock, &auth_response, sizeof(auth_response), 0);	
	if ( res == SOCKET_ERROR || res == INVALID_SOCKET) {
		logprintf( LVL_WARNING, "couldn't recv auth response" );
		return(0);
	}

	if(auth_response.authtype != authtype) {
		logprintf (LVL_WARNING, "not the same authtype" );
		return(0);
	}

	/* pkt_count is the count of the following msg_request packets */
	if(auth_response.pkt_count < 1) {
		return(0);
	} else {
		pkt_count = auth_response.pkt_count;
	}

	switch(authtype) {	
		case 1:
				if (!strncmp (auth_response.password, password, strlen(password))) {
					res = send_auth_request(sock, authtype, 1);
					logprintf (LVL_MESSAGE, "authentication successfull" );
					return(pkt_count);
				} else {
					logprintf (LVL_WARNING, "authentication failed" );
					res = send_auth_request(sock, 1, 2);
					return(0);
				}
				break;

		case 2:
				if (!strncmp (auth_response.password, (char *)(crypt(password, "dr")), strlen(password))) {
					res = send_auth_request(sock, authtype, 1);
					logprintf (LVL_MESSAGE, "authentication successfull" );
					return(pkt_count);
				} else {
					logprintf (LVL_WARNING, "authentication failed" );
					res = send_auth_request(sock, 1, 2);
					return(0);
				}
				break;

		case 3:
				if (!strncmp (auth_response.password, 
					(char *)(crypt(password, "$i$unitednf")), strlen(auth_response.password))) {
					res = send_auth_request(sock, authtype, 1);
					logprintf (LVL_MESSAGE, "authentication successfull" );
					return(pkt_count);
				} else {
					logprintf (LVL_WARNING, "authentication failed" );
					res = send_auth_request(sock, 1, 2);
					return(0);
				}
				break;
		
		default: logprintf (LVL_WARNING, "unknown authentication method" );
				 break;
	}
	
return(0);
}


/*
 * handle_connection()
 *
 * parameters:
 *
 * SOCKET	sock		the socket to read msgs from
 *
 * handles the complete connection process
*/

int	handle_connection (SOCKET sock)
{
	int	res = 1;
	int pkt_count = 0;
	int n;
	struct _msg_request *nport;
	struct sigaction siga;
	
	if (sock == INVALID_SOCKET) return(0);


	/* initialize signal handler for pcap */
	siga.sa_handler = alarm_handler;
	sigemptyset (&siga.sa_mask);
	siga.sa_flags = 0;
	sigaction (SIGALRM, &siga, NULL);

	/* pkt count is the count of the packets that are coming */
	pkt_count = authorize(sock);
   	if (pkt_count < 1) {
		close(sock);
		logprintf(LVL_ERROR, "too few packets (%i)", pkt_count);
		return(0);
	}


	for(n=0; n<pkt_count; n++)
	{
		nport = malloc (sizeof (struct _msg_request));
		if (! nport) {
			logprintf( LVL_ERROR, "failed malloc" );
			return(0);
		}

		/* now, we are going to take all the fucking packets */
		res = recv( sock, (char*)nport, sizeof(msg_request), 0 );

		if (res == SOCKET_ERROR) {
			logprintf( LVL_ERROR, "lost client connection" );
			return(0);
		}

		if (res == 0) {
			logprintf( LVL_ERROR, "connection closed" );
			return(0);
		}

		if (! list_insert (nport)) {
			free(nport);
			logprintf( LVL_ERROR, "failed malloc" );
		}
	}

	/* evaluate the packets */
	evaluate_message (sock, pkt_count);

return(1);
}


/*
 * server loop
 *
 * accepts connections and forks 
 *
*/

void	server_loop()
{
	SOCKET			connectionsocket;
	SOCKADDR_IN		clientaddr;
	int				addrsize = sizeof(SOCKADDR_IN);

	logprintf( LVL_DEBUG, "entering server_loop()");

	while(1)
	{
		connectionsocket = accept( listensocket, (struct sockaddr*)&clientaddr, &addrsize );

		if(connectionsocket >= 0) {
			logprintf( LVL_MESSAGE, "incoming connection from: %s", inet_ntoa( clientaddr.sin_addr ) ); 

			if(fork() == 0) {
				close(listensocket);
				srandom(getpid());

				liste = list_create();
				if (!liste) {
					printf("Could create list!\n");
					exit(1);
				}				

				/* talk with the client */
				handle_connection( connectionsocket );

				/* scan has finishd, client is disconnect, now cleanup */
  				pcap_close (libpcap_socket);

			   if (libnet_close_raw_sock(libnet_socket) == -1)
			   {
			      libnet_error (LN_ERR_WARNING, "libnet_close_raw_sock couldn't close the interface");
			   }

				list_delall();
				close (connectionsocket);
				shutdown (connectionsocket, 0);
				exit(0);
			}

			close(connectionsocket);

		} else {
			logprintf( LVL_ERROR, "socket error");
		}

		connectionsocket = INVALID_SOCKET;
	}
}
