/*  Copyright (C) 2001  Dobin Rutishauser               anthraxx@gmx.net
                        Bjrn Paetzel                     kolrabi@gmx.de
   
  ------------------------------------------------------------------------

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation;  either  version 2 of the  License, or
    any later version.

    This program is distributed in the hope that it  will be useful, but
    WITHOUT  ANY  WARRANTY;  without   even  the  implied   warranty  of
    MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU
    General Public License for more details.
	
    You should have received a copy  of the  GNU  General Public License
    along with this program (GPL.TXT); if not, write to the 

	Free Software Foundation, Inc., 
	59 Temple Place, Suite 330, 
	Boston, MA
	02111-1307, USA.
*/

#include <pcap.h>
#include "../common/messages.h"


extern	int         libnet_socket;
extern	pcap_t      *libpcap_socket;


struct _infopacket {
        in_addr_t dst_ip;
        u_short dst_port;
        u_short src_port;
        unsigned short mode;
        unsigned short timeout;
        u_long seq_nr;
};


int	initialise_sockets(void);
int	evaluate_message (SOCKET sock, int pkt_count);
int	send_auth_request(SOCKET sock, int authtype, int flag);
int	authorize(SOCKET sock);
int	handle_connection(SOCKET sock);
void	server_loop();
