/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: aout.h,v 1.6 2002/01/05 19:44:23 cosine Exp $
 */

#ifndef INCLUDED_aout_h
#define INCLUDED_aout_h

#ifndef INCLUDED_sys_types_h
#include <sys/types.h>
#define INCLUDED_sys_types_h
#endif

#ifndef INCLUDED_a_out_h
#include <a.out.h>
#define INCLUDED_a_out_h
#endif

/*
 * Lame linux bandaids
 */
#if !defined(N_GETMAGIC) && defined(N_MAGIC)
# define N_GETMAGIC N_MAGIC
#endif

#if !defined(N_GETFLAG) && defined(N_FLAGS)
# define N_GETFLAG N_FLAGS
#endif

struct aoutParameters
{
  unsigned int virtualEntryPoint;
  unsigned int entryPoint;
};

struct aoutWorkspace
{
  struct exec *ExecHeader;    /* pointer to exec header */
  char *filename;             /* name of a.out file */
};

/*
 * Prototypes
 */

struct aoutWorkspace *initAout();
void termAout(struct aoutWorkspace *ws);
int checkAout(struct aoutWorkspace *ws, char *filename, void *ptr, size_t size,
              struct aoutParameters *params);
void printHeaderAout(struct aoutWorkspace *ws);
void printSectionInfoAout(struct aoutWorkspace *ws, char *sname);

#endif /* INCLUDED_aout_h */
