/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: disassemble.h,v 1.5 2002/04/11 01:26:18 cosine Exp $
 */

#ifndef INCLUDED_disassemble_h
#define INCLUDED_disassemble_h

#ifndef INCLUDED_defs_h
#include "defs.h"        /* USE_CURSES */
#define INCLUDED_defs_h
#endif

#ifndef INCLUDED_main_h
#include "main.h"        /* struct aldWorkspace */
#define INCLUDED_main_h
#endif

struct disassembleWorkspace
{
  unsigned long NextInstruction;    /* address of next instruction */

  unsigned int CurrentSectionStart; /* start address of current section */

  unsigned int flags;               /* flags passed to DisAssemble() */
};

/*
 * Prototypes
 */

struct aldWorkspace;

struct disassembleWorkspace *initDisassemble();
void termDisassemble(struct disassembleWorkspace *ws);
long procDisassemble(struct disassembleWorkspace *ws, unsigned char *data,
                     unsigned int address, unsigned int owin);
void DisplayNextInstruction(struct aldWorkspace *main_p);

/*
 * External declarations
 */
extern unsigned int            DisassembleFlags;

#endif /* INCLUDED_disassemble_h */
