/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: set.h,v 1.5 2002/06/29 14:16:16 cosine Exp $
 */

#ifndef INCLUDED_set_h
#define INCLUDED_set_h

#ifndef INCLUDED_main_h
#include "main.h"
#define INCLUDED_main_h
#endif

#define SET_DISPLAY_REGS       (1 << 0)
#define SET_DISPLAY_FP_REGS    (1 << 1)
#define SET_DISPLAY_MMX_REGS   (1 << 2)

#define SetStepDisplayRegs(x)       ((x)->settings |= SET_DISPLAY_REGS)
#define SetStepDisplayFpRegs(x)     ((x)->settings |= SET_DISPLAY_FP_REGS)
#define SetStepDisplayMmxRegs(x)    ((x)->settings |= SET_DISPLAY_MMX_REGS)

#define IsSetStepDisplayRegs(x)     ((x)->settings & SET_DISPLAY_REGS)
#define IsSetStepDisplayFpRegs(x)   ((x)->settings & SET_DISPLAY_FP_REGS)
#define IsSetStepDisplayMmxRegs(x)  ((x)->settings & SET_DISPLAY_MMX_REGS)

#define UnsetStepDisplayRegs(x)     ((x)->settings &= ~SET_DISPLAY_REGS)
#define UnsetStepDisplayFpRegs(x)   ((x)->settings &= ~SET_DISPLAY_FP_REGS)
#define UnsetStepDisplayMmxRegs(x)  ((x)->settings &= ~SET_DISPLAY_MMX_REGS)

/*
 * Prototypes
 */

void DisplaySettings(struct aldWorkspace *ws);

/*
 * External declarations
 */

struct Command;

extern struct Command        setcmds[];

#endif /* INCLUDED_set_h */
