/*
 * libOp
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: modsib-x86.h,v 1.2 2002/04/24 21:04:19 cosine Exp $
 */

#ifndef INCLUDED_modsib_x86_h
#define INCLUDED_modsib_x86_h

#ifndef INCLUDED_disasm_x86_h
#include "disasm-x86.h"         /* BITSXX, REGISTER */
#define INCLUDED_disasm_x86_h
#endif

/*
 * Structure containing info about ModRM or SIB bytes
 */
struct ModSib
{
  int index;          /* name of address offset (M_xxx) */
  unsigned int value; /* value of ModR/M (or SIB) byte */
  unsigned int flags; /* bit flags */
};

#define NUMVALUES  9

/*
 * These indices correspond to the ModSibOffsets[] table
 */
enum
{
  M_AH,
  M_AL,
  M_AX,
  M_BH,
  M_BL,
  M_BP,
  M_BX,
  M_BP_DI,
  M_BP_SI,
  M_BX_DI,
  M_BX_SI,
  M_CH,
  M_CL,
  M_CX,
  M_DH,
  M_DI,
  M_DL,
  M_DX,
  M_EAX,
  M_EBP,
  M_EBX,
  M_ECX,
  M_EDI,
  M_EDX,
  M_ESI,
  M_ESP,
  M_MM0,
  M_MM1,
  M_MM2,
  M_MM3,
  M_MM4,
  M_MM5,
  M_MM6,
  M_MM7,
  M_SI,
  M_SP,
  M_XMM0,
  M_XMM1,
  M_XMM2,
  M_XMM3,
  M_XMM4,
  M_XMM5,
  M_XMM6,
  M_XMM7,
  M_NONE
};

/*
 * Prototypes
 */

int FindModSib(unsigned char *data, struct OpCode *opptr,
               unsigned int bytes, struct ModSib **modptr,
               struct ModSib **sibptr);
struct ModSib *GetModAddress(unsigned char byte, unsigned int pflags);
struct ModSib *GetSibAddress(unsigned char index);
int FindModRegister(unsigned char reg, unsigned int operand);
int FindModRegisterByRM(unsigned char rm, unsigned int operand);

/*
 * External declarations
 */

extern char                 *ModSibOffsets[];
extern char                 *SibBaseRegisters[];

#endif /* INCLUDED_modsib_x86_h */
