/*
 * libOp
 *
 * Copyright (C) 2000 Patrick Alken
 * This library comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: disasm.c,v 1.4 2002/04/09 00:41:28 cosine Exp $
 */

#include "configOp.h"

long x86DisAssemble(unsigned char *data, char *outbuf,
                    unsigned int flags);

/*
DisAssemble()
 Call the appropriate disassemble function for the platform we're
using with the given arguments.

Inputs: data   - data to be disassembled
        outbuf - buffer to store result in
        flags  - various bitmasks (OP_xxx)

Return: number of bytes disassembled
        If an error occurs, -1 is returned, and an appropriate error
        message is printed to 'outbuf'
*/

long
DisAssemble(unsigned char *data, char *outbuf, unsigned int flags)

{
#ifdef INTEL86

  return (x86DisAssemble(data, outbuf, flags));

#endif
} /* DisAssemble() */
