/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_disable.c,v 1.5 2002/04/11 01:26:20 cosine Exp $
 */

#include <stdlib.h>

#include "main.h"
#include "msg.h"
#include "print.h"

/*
 * libDebug includes
 */
#include "break.h"

/*
 * libString includes
 */
#include "Strn.h"

/*
c_disable()
  Disable a breakpoint
*/

void
c_disable(struct aldWorkspace *ws, int ac, char **av)

{
  long num;
  char *endptr;
  struct Breakpoint *ptr;

  if (ac < 2)
  {
    Print(ws, P_COMMAND, "Syntax: disable <number | all>");
    return;
  }

  if (!Strcasecmp(av[1], "all"))
    num = 0;
  else
  {
    num = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(ws, P_ERROR, MSG_INVADDR, av[1]);
      return;
    }
  }

  if (num)
  {
    ptr = findBreakpointByNumber(ws->debugWorkspace_p, num);
    if (!ptr)
      Print(ws, P_ERROR, "No such breakpoint number: %ld", num);
    else
      deactivateBreakpoint(ws->debugWorkspace_p, ptr);
  }
  else
    deactivateBreakpoint(ws->debugWorkspace_p, 0);
} /* c_disable() */
