/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_enter.c,v 1.7 2002/04/11 01:26:21 cosine Exp $
 */

#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "main.h"
#include "msg.h"
#include "output.h"
#include "print.h"

#include "libDebug.h"

/*
c_enter()
  Enter value(s) into memory

Format for this command:
  enter <address> [value]
*/

void
c_enter(struct aldWorkspace *ws, int ac, char **av)

{
  unsigned long address;
  unsigned long value;
  int gotvalue;
  char *endptr;

  if (ac < 2)
  {
    Print(ws, P_COMMAND, "Syntax: enter <address> [value]");
    return;
  }

  address = strtoul(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != 0))
  {
    Print(ws, P_COMMAND, MSG_INVADDR, av[1]);
    return;
  }

  gotvalue = 0;
  value = 0;
  if (ac > 2)
  {
    value = strtoul(av[2], &endptr, 0);
    if ((endptr == av[2]) || (*endptr != '\0'))
    {
      Print(ws, P_COMMAND, MSG_INVADDR, av[2]);
      return;
    }
    gotvalue = 1;
  }

  if (gotvalue)
  {
    if (!setMemoryDebug(ws->debugWorkspace_p, address, value))
    {
      Print(ws, P_COMMAND, MSG_NOACCESS, address, strerror(errno));
      return;
    }
  }
  else
  {
    int done;
    int ret = 1;
    char str[MAXLINE];

    /*
     * No value given - prompt them to enter values
     */
    Print(ws,
          P_COMMAND,
          "Enter new memory contents starting at location 0x%08lX (leave blank to stop)",
          address);

    done = 0;
    while (!done)
    {
      sprintf(str, "0x%08lX: ", address);
      value = NumPrompt(str, &done);
      if (!done)
      {
        ret = setMemoryDebug(ws->debugWorkspace_p, address, value);
        if (ret == 0)
        {
          Print(ws, P_COMMAND, MSG_NOACCESS, address, strerror(errno));
          return;
        }
      }

      address += ret;
    } /* while (!done) */
  }
} /* c_enter() */
