/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_ignore.c,v 1.5 2002/04/11 01:26:21 cosine Exp $
 */

#include <stdlib.h>

#include "main.h"
#include "msg.h"
#include "print.h"

/*
 * libDebug includes
 */
#include "break.h"

/*
c_ignore()
  Set the ignore count for a breakpoint
*/

void
c_ignore(struct aldWorkspace *ws, int ac, char **av)

{
  long num,
       count;
  char *endptr;
  struct Breakpoint *ptr;

  if (ac < 3)
  {
    Print(ws, P_COMMAND, "Syntax: ignore <number> <count>");
    return;
  }

  num = strtol(av[1], &endptr, 0);
  if ((endptr == av[1]) || (*endptr != '\0'))
  {
    Print(ws, P_ERROR, MSG_INVNUM, av[1]);
    return;
  }

  ptr = findBreakpointByNumber(ws->debugWorkspace_p, num);
  if (!ptr)
  {
    Print(ws, P_ERROR, "No such breakpoint number: %ld", num);
    return;
  }

  count = strtol(av[2], &endptr, 0);
  if ((endptr == av[2]) || (*endptr != '\0'))
  {
    Print(ws, P_ERROR, MSG_INVNUM, av[2]);
    return;
  }

  setIgnoreCount(ptr, count);
} /* c_ignore() */
