/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_set.c,v 1.6 2002/04/13 17:52:39 cosine Exp $
 */

#include "command.h"
#include "main.h"
#include "print.h"
#include "set.h"

/*
c_set()
  Configure various settings
*/

void
c_set(struct aldWorkspace *ws, int ac, char **av)

{
  struct Command *cptr;
  unsigned int flags;

  if (ac < 2)
  {
    DisplaySettings(ws);
    return;
  }

  flags = 0;
  cptr = FindCommand(setcmds, av[1], &flags);
  if (cptr)
  {
    /*
     * Call cptr->func to execute command
     */
    (*cptr->funcptr)(ws, ac, av, 0);
  }
  else
  {
    /*
     * They gave us an invalid setting
     */
    Print(ws,
          P_COMMAND,
          "%s command: set %s",
          (flags & C_AMBIGUOUS) ? "Ambiguous" : "Unknown",
          av[1]);
  }
} /* c_set() */
