/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_write.c,v 1.5 2002/04/11 01:26:22 cosine Exp $
 */

#include <errno.h>
#include <string.h>

#include "alddefs.h"
#include "main.h"
#include "print.h"
#include "scroll.h"
#include "window.h"

/*
c_write()
  Dump contents of current window to a file

Inputs: av[1] - filename
*/

void
c_write(struct aldWorkspace *ws, int ac, char **av)

{
#ifdef USE_CURSES

  char filebuf[MAXLINE];
  FILE *fp;

  if (ac < 2)
    strcpy(filebuf, "ald.out");
  else
    strcpy(filebuf, av[1]);

  if (!(fp = fopen(filebuf, "w")))
  {
    Print(ws,
          P_ERROR,
          "Unable to open %s: %s",
          filebuf,
          strerror(errno));
    return;
  }

  if (DumpCurrentWindow(fp))
    Print(ws, P_COMMAND, "Active window dumped to %s", filebuf);

  fclose(fp);

#endif /* USE_CURSES */
} /* c_write() */
