/* api_error.h : string table for bastard error messages */


struct BASTARD_ERR {
	int errnum;
	char *errstr;
} static _bastard_error_table[] = {
	{1001, "Cannot intialize"},
	/* bastard.c */
	{1010, "Cannot open new STDIN"},
	{1011, "Cannot open new STDOUT"},
	{1012, "Cannot open new STDERR"},
	/* db.c -- the DB errors are from typhoon */
	{1998, "DB : No current record" },
	{1999, "DB : No current DB" },
	{2000, "Database Error" },
	{2001, "DB : S_NOTFOUND"},
	{2002, "DB : S_DUPLICATE"},
	{2003, "DB : S_DELETED"},
	{2004, "DB : S_RESTRICT"},
	{2005, "DB : S_FOREIGN"},
	{2008, "DB : S_LOCKED"},
	{2009, "DB : S_UNLOCKED"},
	{2010, "DB : S_VERSION"},
	{2011, "DB : S_INVPARM"},
	{2200, "DB : S_NOMEM"},
	{2201, "DB : S_NOTAVAIL"},
	{2202, "DB : S_IOFATAL"},
	{2203, "DB : S_FATAL"},
	{2500, "DB : S_MAXCLIENTS"},
	{2501, "DB : S_NOSERVER"},
	{3000, "DB : S_INVDB"},
	{3001, "DB : S_INVREC"},
	{3002, "DB : S_INVFLD"},
	{3003, "DB : S_NOTKEY"},
	{3004, "DB : S_RECSIZE"},
	{3005, "DB : S_BADTYPE"},
	{3006, "DB : S_INVKEY"},
	{3007, "DB : S_INVADDR"},
	{3008, "DB : S_INVSEQ"},
	{1999, "DB : S_NOCD"},
	{1998, "DB : S_NOCR"},
	/* macro.c */
	{3010, "Unable to load EiC include file"},
   {3020, "Unable to open temp file for macro"},
	{3030, "Cannot run EiC scripts from within EiC"},
	/* api_address.c */
	{4020, "No ADDRESS exists for given rva"},
	{4021, "Bad rva or size in parameters"},
	{4022, "ADDRESS is not a CODE object"},
	{4023, "ADDRESS is not a DATA object"},
	{4030, "No rel address exists with given phys addr"},
	{4040, "Specified address lies outside the target file"},
	/* api_code.c */
	{4110, "No CODE exists for given addr"},
	{4120, "Address has already been disassembled"},
	{4130, "Address is in a disassembled CODE instruction"},
	{4150, "No INT_CODE exists for given id"},
	{4170, "No FIN_CODE exists for given id"},
	/* api_disasm.c */
	{4200, "Unable to load Arch disassembler Extension"},
	{4210, "Address does not exist for given code object"},
	{4230, "ARCH Extension not loaded"},
	{4240, "Unable to disassemble address"},
	/* api_functions.c */
	{4300, "No FUNCTION exists for given id"},
	{4310, "No function exists for given addr"},
	{4320, "No function exists with given name"},
	{4330, "No FUNC_PARAM exists for given id"},
	{4340, "No FUNC_LOCAL exists for given id"},
	{4350, "No F_INLINE exists for given id"},
	{4370, "No INLINE_TYPE exists for given id"},
	/* api_importexport.c */
	{4400, "No IMPORT exists for given addr"},
	{4410, "No Library exists with given name"},
	{4411, "No LIB exists for given id"},
	{4450, "No EXPORT exists for given addr"},
	{4451, "No EXPORT exists with given name"},
	/* api_loadsave.c */
	{4500, "Target does not exist"},
	{4501, "Previously saved .bdb exists for target in $DB_PATH"},
	{4502, "Found .bdb dir from previous (aborted) load of target"},
	{4510, "Unable to create ./.bdb directory"},
	{4511, "Unable to remove ./.bdb directory"},
	{4520, "Unable to open ./.bdb directory"}, 
	{4530, "Unable to create target DB in ./.bdb"},
	{4540, "Unable to create target image in ./.bdb"},
	{4550, "Cannot open database"},
	{4560, "Cannot open .bdb file [tar error]"},
	{4561, "Invalid .bdb file!"},
	{4565, "Cannot save target .bdb file [tar error]"},
	{4580, "Unable to init Extension"},
	{4581, "Unable to initialize Architecture Extension"},
	{4582, "Unable to initialize Assembler Extension"},
	{4583, "Unable to initialize Engine Extension"},
	{4584, "Unable to initialize File Format Extension"},
	{4585, "Unable to initialize Language Extension"},
	{4586, "Unable to initialize Plugin Extension"},
	{4590, "Unable to load Extension"},
	{4591, "Specified Architecture Extension not found"},
	{4592, "Specified Assembler Extension not found"},
	{4593, "Specified Engine Extension not found"},
	{4594, "Specified File Format Extension not found"},
	{4595, "Specified Language Extension not found"},
	{4596, "Specified Plugin Extension not found"},
	/* api_macros.c */
	{4600, "No MACRO exists for given id"},
	{4601, "No MACRO exists for given name"},
	{4610, ""},
	{4620, ""},
	{4630, ""},
	/* api_namecomment.c */
	{4710, "No NAME exists for given addr"},
	{4711, "No such NAME exists"},
	{4720, "No COMMENT exists for given addr"},
	{4730, "No COMMENT exists for given id"},
	/* api_section.c */
	{4810, "Section already exists"},
	{4820, "No SECTION exists for given name"},
	/* api_search.c */
	{4910, "Value not found"},
	/* api_strings.c */
	{5000, "No STRING exists for given addr"},
	{5010, "String does not exist"},
	/* api_structconst.c */
	{5100, "No CONSTANT exists for given id"},
	{5110, "No CONSTANT exists for given name"},
	{5120, "No CONSTANT exists for given value"},
	{5150, "No STRUCTURE exists for given id"},
	{5160, "No STRUCT_MEMBER exists for given id"},
	{5170, "No DATATYPE exists for given id"},
	/* api_system.c */
	{5200, "Unable to launch external program"},
	/* api_xref.c */
	{5300, "'From' xref does not exist for given addr"},
	{5310, "No XREF exists for given ID"},
	{5320, "'To' xref does not exist for given addr"},
	/* api_env.c */
	{5400, "$BASTARD_HOME does not contain valid include directory"},
	/* generic errors */
	{9010, "Invalid pointer passed as parameter"},
	{9020, "File does not exist"},
	{9030, "Cannot open file"},
	{9050, "Malloc error: out of heap space\n"},
	{0, "NULL"}
};
