/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */
#include <extensions/os.h>	/* for sysref stuff */

/* Public Parts */
    /* Xref Types */
#define XREF_READ      0x01
#define XREF_WRITE   0x02
#define XREF_EXEC      0x04
/*  GetRefTo: 
 *    Return Value: from_rva or 0 if no matches   
 *     Arguments:     rva  -- address to find references to
 *                    type -- type of xref to match [OP_R | OP_W | OP_X] or 0 */
long xref_to( long rva, int type ) ;       //get first
/*  GetNextRefTo: 
 *    Return Value:   from_rva or 0 if no more matches   
 *     Arguments:     type -- type of xref to match [OP_R | OP_W | OP_X] or 0 */
long xref_to_next( int type ) ; //get array of structs; return num
/*  GetRefFrom: 
 *    Return Value: to_rva or 0 if no matches   
 *     Arguments:     rva  -- address to find references from
 *                    type -- type of xref to match [OP_R | OP_W | OP_X] or 0 */
long xref_from( long rva, int type ) ;
/*  GetNextRefFrom: 
 *    Return Value: to_rva or 0 if no more matches   
 *     Arguments:     type -- type of xref to match [OP_R | OP_W | OP_X] or 0 */
long xref_from_next( int type ) ;
/*  DefineRef: 
 *    Return Value: 1 on success, 0 on error 
 *     Arguments:       */
int xref_new( long from, long to, int type );


/* SYSREFS -- References to OS system calls, exception handlers, or devices 
 *            from CODE instructions. */

/* sysref_new:		create a new SYSREF record in the DB
 *   Return Value:	id of new SYSREF, or 0 on error 
 *   Arguments:		type -- type of SYSREF from extensions/os.h
 *   				ref  -- EXT_OS internal id for SYSREF (e.g., syscall #)
 *   				rva  -- rva which makes this reference */
int sysref_new( int type, int ref, unsigned long rva );
/* sysref_fromcode:	create a new sysref by analyzing the code struct
 *   Return Value:	id of new SYSREF, or 0 on error
 *   Arguments:		c -- Instruction suspected of being a SYSREF */
int sysref_fromcode( struct code *c);
/* sysref_from:		return the ID of the first SYSREF from the rva
 *   Return Value:	id of SYSREF or 0 on error/not-found
 *   Arguments:		rva -- address referencing SYSREF */
int sysref_from( unsigned long rva);
/* sysref_get_type:	return the type field of the SYSREF # id
 *   Return Value:	type field or 0 on error
 *   Arguments:		id -- id field of SYSREF */
int sysref_get_type( int id );
/* sysref_get_subtype:	return the subtype field of the SYSREF # id
 *   Return Value:	type field or 0 on error
 *   Arguments:		id -- id field of SYSREF */
int sysref_get_subtype( int id );
/* sysref_get_name:	get the ASCII name of the SYSREF item (e.g., syscall)
 *   Return Value:	length of string copied to buf, or 0 on error
 *   Arguments:		id  -- id field if SYSREF
 *   				buf -- buffer to store name in
 *   				len -- length of buffer */
int sysref_get_name( int id, char *buf, int len );
/* sysref_sprint:		print string representing SYSREF to buf
 *   Return Value:	length of string or 0 on error
 *   Arguments:		s   -- SYSREF struct
 *   				buf -- buffer to print string to
 *   				len -- length of buffer */
int sysref_sprint( struct sysref *s, char *buf, int len);

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
