/* bastard api -- these should be called from the macro language and the prog */
#ifndef BASTARD_API_INCLUDE /* prevent redeclaration errors in scripts */
   #define BASTARD_API_INCLUDE
   #define INCLUDED_FROM_BASTARD_H

   #ifndef PATH_MAX
      #include <dirent.h>
   #endif

/* Contents:_________________________________________________________________
 1.  Low-Level DB Interface
 2.  Generic Object Access
 3.  Low-Level Disassembler Access
 4.  Loading
 5.  Saving
 6.  Sections
 7.  Disassembly
 8.  Addresses
 9.  Names & Comments
 10. Structures & Constants
 11. Code
 12. Strings
 13. Imports
 14. Exports
 15. XRefs
 16. Functions
 17. Macros
 18. Search
 19. System Interaction                                                  */

/* Notes:_________________________________________________________________
 * + The following naming conventions are used:
 *       rva       Relative Virtual Address -- the address of a location of
 *                   code or data once the program has been loaded by the OS
 *       pa        Physical Address -- the offset of a location of code or
 *                   data within the executable file/image.
 *
 * + Most routines return 0 on error or failure; the reason for the error can
 *   be found by calling GetLastError();
 *   
 * + Routines that take character arrays as arguments generally do not require
 *   the length of the array. This because the strings in the DB are of
 *   fixed length [see bdb.h], and thus it simple enough for the caller to
 *   know the size of array they should use. Naturally this goes against all
 *   sane security practice; however anyone incorporating a program such as
 *   the bastard into their firewalling policy is pretty much beyond saving.
 *   Be warned: you are expected to know what you are doing.
 */

   /* Types */
   typedef void (*BAPI_CALLBACK)(void *item, void *data);
   
   /* DB Interface -- db.c
      ===================================================================== */
   #include <db/db.h>

   /* Bastard Extensions -- extension.c
      ===================================================================== */
   #include <api/api_plugin.h>


   /* Loading and Saving -- api_loadsave.c
      ===================================================================== */
   #include <api/api_target.h>

   /* Sections -- api_section.c
      ===================================================================== */
   #include <api/api_section.h>

   /* Disassembly -- api_disasm.c
      ===================================================================== */
   #include <api/api_disasm.h>

   /* Addresses -- api_address.c
      ===================================================================== */
   #include <api/api_addr.h>

   /* Names & Comments -- api_namecmt.c
      ===================================================================== */
   #include <api/api_name.h>
   #include <api/api_comment.h>

   /* Structures & Constants -- api_structconst.c
      ===================================================================== */
   #include <api/api_dtype.h>
   #include <api/api_struct.h>
   #include <api/api_const.h>

   /* Code -- api_code.c
      ===================================================================== */
   #include <api/api_code.h>

   /*   Address Expressions -- api_code.c
      ===================================================================== */
   #include <api/api_addrexp.h>

   /* Intermediate Code -- api_intcode.c
      ===================================================================== */
   #include <api/api_intcode.h>

   /*   Strings -- api_strings.c
      ===================================================================== */
   #include <api/api_string.h>

   /* Imports -- api_importexport.c
      ===================================================================== */
   #include <api/api_imp.h>
   #include <api/api_lib.h>

   /* Exports -- api_importexport.c
      ===================================================================== */
   #include <api/api_exp.h>

   /* XRefs and Sysrefs -- api_xref.c
      ===================================================================== */
   #include <api/api_xref.h>

   /* Functions -- api_functions.c
      ===================================================================== */
   #include <api/api_func.h>

   /* Macros -- api_macros.c
      ===================================================================== */
   #include <api/api_macro.h>

   /* Search -- api_search.c
      ===================================================================== */
   #include <api/api_search.h>
			 
   /* Bastard Environment -- api_env.c
      ===================================================================== */
   #include <api/api_env.h>

   /* System Interaction -- api_system.c
      ===================================================================== */
   #include <api/api_sys.h>


#endif /* prevent redeclaration errors in scripts */
