/*---------- headerfile for src/cfg.ddl ----------*/
/* alignment is 4 */

/*---------- structures ----------*/
struct profile_env {  /* size 612 */
    char    user[32];
    char    home[256];
    char    p1[16];
    char    p2[16];
    char    p3[16];
    char    p4[16];
    char    dbpath[256];
    int     output;
};

struct profile_pref {  /* size 932 */
    char    user[32];
    char    arch[32];
    char    asmblr[32];
    char    format[32];
    char    lang[32];
    char    pager[256];
    char    editor[256];
    char    debugger[256];
    int     options;
};

struct profile_asm {  /* size 1056 */
    char    name[32];
    char    asm_ttyColor[128];
    char    data_ttyColor[128];
    char    asm_ttyMono[128];
    char    data_ttyMono[128];
    char    asm_file[128];
    char    data_file[128];
    char    asm_lpr[128];
    char    data_lpr[128];
};

struct profile_arch {  /* size 36 */
    char    name[32];
    int     options;
};

struct hist_macro {  /* size 2084 */
    int     type;
    char    name[32];
    char    macro_text[2048];
};

struct hist_cmd {  /* size 260 */
    int     id;
    char    cmd[256];
};

struct profile_target {  /* size 712 */
    char    name[64];
    char    path[256];
    char    dbname[256];
    int     size;
    long    entry;
    char    arch[32];
    char    asmblr[32];
    char    format[32];
    char    lang[32];
};

/*---------- record names ----------*/
#define PROFILE_ENV 1000L
#define PROFILE_PREF 2000L
#define PROFILE_ASM 3000L
#define PROFILE_ARCH 4000L
#define HIST_MACRO 5000L
#define HIST_CMD 6000L
#define PROFILE_TARGET 7000L

/*---------- field names ----------*/
#define PROFILE_ENV_USER 1001L
#define HOME 1002L
#define P1 1003L
#define P2 1004L
#define P3 1005L
#define P4 1006L
#define DBPATH 1007L
#define OUTPUT 1008L
#define PROFILE_PREF_USER 2001L
#define PROFILE_PREF_ARCH 2002L
#define PROFILE_PREF_ASMBLR 2003L
#define PROFILE_PREF_FORMAT 2004L
#define PROFILE_PREF_LANG 2005L
#define PAGER 2006L
#define EDITOR 2007L
#define DEBUGGER 2008L
#define PROFILE_PREF_OPTIONS 2009L
#define PROFILE_ASM_NAME 3001L
#define ASM_TTYCOLOR 3002L
#define DATA_TTYCOLOR 3003L
#define ASM_TTYMONO 3004L
#define DATA_TTYMONO 3005L
#define ASM_FILE 3006L
#define DATA_FILE 3007L
#define ASM_LPR 3008L
#define DATA_LPR 3009L
#define PROFILE_ARCH_NAME 4001L
#define PROFILE_ARCH_OPTIONS 4002L
#define TYPE 5001L
#define HIST_MACRO_NAME 5002L
#define MACRO_TEXT 5003L
#define ID 6001L
#define CMD 6002L
#define PROFILE_TARGET_NAME 7001L
#define PATH 7002L
#define DBNAME 7003L
#define SIZE 7004L
#define ENTRY 7005L
#define PROFILE_TARGET_ARCH 7006L
#define PROFILE_TARGET_ASMBLR 7007L
#define PROFILE_TARGET_FORMAT 7008L
#define PROFILE_TARGET_LANG 7009L

/*---------- key names ----------*/

/*---------- sequence names ----------*/

/*---------- integer constants ----------*/
