#ifndef _PARSER_H
#define _PARSER_H
typedef void (*CmdFn)(int, char **, void *c);
struct COMMAND {
	char command[32];
	char subcmd[32];
	int  sub_tbl;		/* needed for help */
	int  argc;
	char **argv;
	int  extension;
	char *cline;
	CmdFn fn;
};


struct ACTION {
		  char *name;
		  char alias;
		  int sub_cmd;
		  void *handler;
		  char *helpstr;
} ;

struct SUBACTION {
	char *name;
	void *handler;
	char *helpstr;
};

/* protos */
typedef void (*CmdHandler)(int, char **, struct COMMAND *c);
void *cmd_help(int argc, char **argv, struct COMMAND *c);
void *subcmd_help(int argc, char **argv, struct COMMAND *c);
int ProcessCommand( char *buf);
#endif
