#ifndef BASTARD_DB_BDB_H
#define BASTARD_DB_BDB_H

/* BDB Database-specific Interface -- db.c
   ======================================================================== */

   /*   These expect *dest to be pre-allocated */
   int bdb_index_first(int index, void *dest);
   int bdb_index_next(int index, void *dest);
   int bdb_index_prev(int index, void *dest);
   int bdb_index_last(int index, void *dest);
   int bdb_index_find(int index, void *value, void *dest);
   int bdb_table_first(int table, void *dest);
   int bdb_table_next(int table, void *dest);
   int bdb_table_prev(int table, void *dest);
   int bdb_table_last(int table, void *dest);
   int bdb_record_insert(int table, void *src);
   int bdb_record_update(int index, void *value, void *src);
   int bdb_record_delete(int index, void *value);
   int bdb_find_closest_prev(int index, void *value, void *dest);
   int bdb_find_closest_next(int index, void *value, void *dest);
   int bdb_table_count(int table);

   /* warning: do not call this from scripts! EiC is not re-entrant */
   void bdb_index_foreach(int index, BAPI_CALLBACK func, void *data);

#endif
