#ifndef BASTARD_EXTENSION_H
#define BASTARD_EXTENSION_H
#include <dirent.h>
#include <bdb.h>

/* EXTENSION FLAGS */

/* methods */
#define EXT_METHOD_MASK 0xF000
#define EXT_BC          0x1000
#define EXT_SO          0x2000
/* status */
#define EXT_STATUS_MASK 0x0F00
#define EXT_OPEN        0x0100
#define EXT_INIT        0x0200
#define EXT_CLEANUP     0x0300
#define EXT_CLOSED      0x0400
/* types */
#define EXT_TYPE_MASK   0x00FF
#define EXT_PLUGIN      0x0001
#define EXT_ENGINE      0x0002
#define EXT_ARCH        0x0003
#define EXT_ASM         0x0004 
#define EXT_FORMAT      0x0005
#define EXT_LANG        0x0006
#define EXT_COMP        0x0007
#define EXT_OS          0x0008



typedef void (*ext_init_fn)(void *);
typedef void (*ext_clean_fn)(void);
struct EXTENSION {
   char *filename;      /* name of extension file [full path] */
   int flags;           /* uhh..... */
   void *lib;           /* pointer to library */
   ext_init_fn fn_init;       /* init function for extension */
   ext_clean_fn fn_cleanup;    /* cleanup function for extension */
}; /* these are linked to from standard extensions : hll, engine, etc */


/* EXTENSION ROUTINES */
void init_extensions();
void cleanup_extensions();
int load_extension( int type, char * filename, void *param);
int get_extension_flags( int type );
int unload_extension( int type );



/* EXTENSION .bc WRAPPERS */
/* these enable functions in .bc scripts to be called in place of .so libs */
int plugin_main_stub(void *plugin_arg) ;
int engine_main_stub(void *engine_arg) ;
int read_header_stub(void);
void arch_init_stub(void *param);
void arch_cleanup_stub(void);
int disasm_addr_stub(unsigned char *c, int n, struct code *inst, long rva);
int code_pat_stub( unsigned long rva, int pattern);
int get_prologue_stub(struct code **table);
int get_epilogue_stub(struct code **table);
int gen_effect_stub(struct code *c, struct code_effect *e);
int gen_int_stub(struct function *f);
void asm_init_stub(void *param);
void asm_cleanup_stub(void);
int sprint_code_stub(long rva, char *buf, int len, int output);
int sprint_func_start_stub( char *str, int len, int func_id);
int sprint_func_end_stub( char *str, int len, int func_id);
int sprint_struct_stub(char *str, int len, long rva);
int sprint_section_start_stub(char *str, int len, char *name);
int sprint_section_end_stub(char *str, int len, char *name);
int gen_asmfile_stub( char *path );
int sprint_addrexp_stub(char *str, int len, char *scale, char *index, 
                        char *base, char *disp, int sign);
void os_init_stub(void *param);
void os_cleanup_stub(void);
void sysref_name_stub(struct sysref *s, char *buf, int len);
void sysref_gen_stub(struct code *c, struct sysref *s);
void comp_init_stub(void *param);
void comp_cleanup_stub(void);
int findstr_stub(char *buf, char *text, int text_len, int type);
int datatype_stub(int mach_word);
int genargs_stub(struct function *f);
int func_effect_stub(struct function *f);
int findstr_stub(char *buf, char *text, int text_len, int type);
int makestr_stub(char *buf, int len, int *pos, char *text, int text_len,int type);
void lang_init_stub(void *param);
void lang_cleanup_stub(void);
int sprint_proto_stub(char *buf, int len, int func_id);
int sprint_func_stub(char *buf, int len, int func_id);
int gen_final_stub(int func_id);
int gen_hllfile_stub( char *path);

/* Safe wrappers for EXTENSION fn's -- these check for NULL fn pointers */
int ext_plugin_main(void *param);
int ext_engine_main(void *param);
/* EXT_ARCH */
int ext_disasm_addr(char *buf, char tbl, struct code *c, long rva);
int ext_code_pat(int rva, int type);
int ext_gen_effect(struct code *c, struct code_effect *e);
int ext_gen_int(struct function *f);
/* EXT_COMP */
int ext_add_data_types(int mach_word);
int ext_func_genargs( struct function *f );
int ext_func_geneffect( struct function *f );
int ext_findstr(char *buf, int len, int *pos, char *text, int text_len, int type) ;
int ext_makestr(char *buf, char *text, int text_len, int type);
/* EXT_OS */
int ext_sysref_name( struct sysref *s, char *buf, int len);
int ext_sysref_gen( struct code *c, struct sysref *s);
/* EXT_LANG */
int ext_sprint_hll_proto(char *buf, int len, int func_id);
int ext_sprint_hll_func(char *buf, int len, int func_id);
int ext_gen_final(int func_id);
int ext_gen_hll_file(char *path);
/* EXT_FORMAT */
int ext_read_header(void);
/* EXT_ASM */
int ext_sprint_code(long rva, char *line, int len, int output);
int ext_sprint_addrexp(char *str, int len, char *scale, char *index,
                             char *base, char *disp, int sign);
int ext_sprint_asm_func_start(char *str, int len, int func_id);
int ext_sprint_asm_func_end(char *str, int len, int func_id);
int ext_sprint_asm_struct(char *str, int len, long rva);
int ext_sprint_sec_end(char *str, int len, char *name);
int ext_sprint_sec_start(char *str, int len, char *name);
int ext_gen_asm_file(char *path);
   
/* ENGINES */
int do_engine( char *plugin, char *prefix, int num, int options );
int do_engine_stage( char *plugin, char *stage, int options );

/* for the convenience of those including us :) */
#include <extensions/arch.h>
#include <extensions/asm.h>
#include <extensions/comp.h>
#include <extensions/format.h>
#include <extensions/lang.h>
#include <extensions/os.h>
#include <extensions/engine.h>
#include <extensions/plugin.h> 

#endif
