
/* register types */
#define REG_GENERAL	0x01		/* general-purpose */
#define REG_INPUT		0x02		/* incoming args */
#define REG_OUTPUT	0x04		/* args to subroutines */
#define REG_LOCAL		0x08		/* local vars */
#define REG_FPU		0x10		/* FPU reg */
#define REG_SEG		0x20		/* segment reg */
#define REG_SIMD		0x40		/* simd/mmx stuff */
#define REG_SYS		0x80		/* CPU/OS internal reg */	
#define REG_SP		0x1000	/* stack pointer */
#define REG_FP		0x2000	/* frame pointer */
#define REG_PC		0x4000	/* program counter */
#define REG_RETADD	0x8000	/* return address */
#define REG_CC		0x10000	/* condition code */
#define REG_ZERO		0x20000	/* /dev/null register */
#define REG_RET		0x40000	/* return value */
#define REG_ASRC		0x100000	/* array source */
#define REG_ADEST		0x200000	/* array dest */
#define REG_ACNT		0x400000	/* array length/counter */

struct VM_DATA {
	int flags;
	union {
		unsigned short s;
		unsigned long i;	/* assume long and int are same size */
		unsigned long long l;
		void * p;
		char buf[16];	/* enough for 128 bits */
	}u;
};

/* VM_STACK flags */
#define VM_STACK_DYNVAL	0x01	/* value only determined at runtime */
#define VM_STACK_PTR	0x10	/* value is an address in the program */
#define VM_STACK_RET	0x20	/* value is a return address */
#define VM_STACK_FP	0x40	/* value is a frame pointer */
#define VM_STACK_SP	0x50	/* value is a stack pointer */
#define VM_STACK_SAVE	0xF000

struct VM_STACK {
	struct VM_DATA data;
	struct VM_STACK *prev;
	struct VM_STACK *next;
};

/* table of registers available in the processor */
struct REGTBL_ENTRY {
   int size;
   int type;
   struct VM_DATA data;
   char mnemonic[8];
};

/* REG_STATE (used by XREFS and SYSREFS) */
#define     REGSTATE_SYSREF   1
#define     REGSTATE_XREF     2
#define     REGSTATE_OTHER    0xF


int vm_init( void );
int vm_add_regtbl_entry(int index, char *mnemonic, int size, int type);
char * vm_get_reg_name(int index);
int vm_reg_get_byname( char *name );
int vm_get_reg_size(int index);
int vm_get_reg_type(int index);
int vm_get_num_regs();
void vm_cleanup();
void * vm_do_reg_op(int reg, int op, void *operand);
int vm_read_reg( int reg, struct VM_DATA *dest );
int vm_write_reg( int reg, struct VM_DATA *src );
int vm_init_stack( );
int vm_push_stack( struct VM_DATA *src );
int vm_pop_stack( struct VM_DATA *dest );
int vm_push_operand( long op, unsigned int type );
long vm_pop_operand( long op, unsigned int type );
int vm_frame_stack();
int vm_unframe_stack();
