#include bastard

/* call_tree
   From the rnetry point, reports and follwos all calls & jumps
	made by a program.
*/

int indent;

int PrintIns( code_t *c ){
	int x, *state;
	char buf[64], *dest;

	state = DBSaveState();
	for (x = 0; x < indent; x++)
		printf("\t");

	if (GetName(c->rva, buf))
		dest = buf;
	else dest = c->dest;

	printf("%s %s\n", c->mnemonic, dest);
	DBRestoreState(state);
	return(1);
}

int GetDest( code_t *c) {
	xref_t x;

	//switch (c->destType & 0x0F00){
		//case OP_BPTR:
		//case OP_WPTR:
		//case OP_DPTR:
		
		if (! DBIndexFind(XREF_FROM_RVA, &c->rva, &x)){
					x.to_rva = strtol(c->dest, NULL, 16);
				}
		//case OP_REL:
		//case OP_IND:
		//printf("returning %s/%x from %x/%x\n", c->dest, x.to_rva, x.from_rva, c->rva);
		return(x.to_rva);
}

int CallTree( int rva ) {
	int cont, *state;
	int branch_rva;
	code_t c;

	/* save DB state on entry */
	state = DBSaveState();
	indent++;

	cont = DBIndexFind(CODE_RVA, &rva, &c); 
	while(cont){
		switch (c.mnemType & 0x0F) {
			case INS_BRANCH:
				PrintIns(&c);	
				branch_rva = GetDest(&c);
				if (branch_rva != rva) CallTree(branch_rva);
				cont = 0;
				break;
			case INS_COND:
			case INS_SUB:
				PrintIns(&c);	
				branch_rva = GetDest(&c);
				if (branch_rva != rva) CallTree(branch_rva);
				break;
			case INS_RET:
				cont = 0;
				break;
			default:
				break;
		}
		DBIndexFind(CODE_RVA, &c.rva, &c); 
		if (cont) cont = DBIndexNext(CODE_RVA, &c);
	}
	indent--;
	DBRestoreState(state);
	return(1);
}
/*  -------------------------------------------------------------------main()
*/
int main()
{
	export_t e;
	int cont;
	char buf[64];
	
	indent = 0;
	cont = DBIndexFirst( EXPORT_RVA , &e);
	/* Iterate through entry points */
	while (cont){
		if (GetName(e.rva, buf))
			/* print name of entry */
			printf("%s: \n", buf);
		else printf("%08x: \n", e.rva);

		/* trace forward from here */
		CallTree(e.rva);

		cont = DBIndexNext(EXPORT_RVA, &e);
	}
	
	return(0);
}
