#include <stdio.h>
#include <stdlib.h>

#include <bastard.h>
#include <extension.h>
#include <vm.h>

#define NUM_REGS	1	/* number of registers in the CPU */

struct EXT__ARCH *settings;

void ext_arch_init( struct EXT__ARCH *settings ) {
   if (! settings) return;

   /* create table of register mnemonics */
   settings->sz_regtable = 1;
   settings->reg_table = calloc( sizeof(struct REGTBL_ENTRY), NUM_REGS);
   settings->reg_storage = calloc(32, NUM_REGS);
	/* add an entry in the table for each register */
   vm_add_regtbl_entry( 0, "reg0", 4, 0); /* index, mnemonic, size, type */

   /* set CPU specific information */
   settings->sz_addr = 4;	/* size of address */
   settings->sz_oper = 4;	/* default operand size */
   settings->SP = 0;			/* index of stack ptr in reg_table */
   settings->IP = 0;			/* index of instr ptr in reg_table */
   settings->sz_inst = 0;	/* size of instruction */
   settings->sz_byte = 0;	/* number of bits in byte */
   settings->sz_word = 0;	/* number of bytes in word */
   settings->sz_dword = 0;	/* number or bytes in dword */
   settings->endian = LITTLE_ENDIAN_ORD;	/* or BIG_ENDIAN_ORD */
   return;
}
   
void ext_arch_cleanup( void ) {
   if (settings->reg_table) free(settings->reg_table);
   if (settings->sz_regtable) settings->sz_regtable = 0;
   if (settings->reg_storage) free(settings->reg_storage);
   return;
}

/* --- Exported Information Routines -------------------------------------*/
/* Determine if 'rva' is the start of the specified code pattern */
int test_for_code_pattern(unsigned long rva, int pattern){
	/* A code pattern is an array of struct code fields, representing
	   a sequence of instructions that must be matched for this routine
		to return true. As an example, the Intel code pattern
			push ebp
			mov ebp, esp
			sub esp, *
		could be represented as
			struct code func_prologue_pattern[] = {
				{1, 0, "push", REG_ID(ebp), 0},
				{1, 0, "mov", REG_ID(ebp), REG_ID(esp), 0},
				{1, 0, "sub", REG_ID(esp), 0},
			};
		...which uses 0 as a wildcard value.
	*/
	switch (pattern) {
	case FUNCTION_PROLOGUE:
	case FUNCTION_EPILOGUE:
	default:
		break;
	}
	/* return 1 if current RVA matches pattern */
	return (0);			/* no pattern match */
}

/* determine side effects of the specified instruction */
int gen_code_effect( struct code *c, struct code_effect *e){
   /* c->mnemType is used to determine the effects of instructions
      which are predetermined, e.g. a call or a push affecting the 
      stack pointer; 'e' is filled with the result. All effects 
		dependent on operands are managed by the calling program */
   return(0);
}


/* ------------ Disassembly Routines ----------------------------------- */

/* disassemble an address to a code instruction */
int disasm_addr( char *buf, char tbl, struct code *c, long rva){
    /*   buf points to the loc of the current opcode (start of the 
            intruction) in the instruction stream. The instruction stream
            is assumed to be a buffer of bytes read directly from the file
            for the purpose of disassembly; a mmapped file is ideal for 
            this.
         tbl indicates which table to lookup this opcode in; 0 is the main
            opcode table and is the only table that should be referenced by
            a non-recursive call.
         c   points to a code structure which will be filled by InstDecode
         rva is the virtual address of the current instruction
         returns the size of the decoded instruction in bytes 
	 	NOTE: register operands must be replaced by the index in reg_table
		      for the appropriate register; address expression operands
				must be inserted into the ADDR_EXP table, and the resulting
				ID used as the operand in the instruction.
		WARNING: this function takes no size argument for the buffer; the
				programmer must ensure that the buffer contains enough bytes
				to represent the instruction.
	*/
   int size = 0;

   /* decode instruction here and return size */

   return(size);
}

/* generate an intermediate code representation of a function */
int gen_int(struct function *f) {
	/* this iterates through the function, adding records to INT_CODE table */
	return(0);
}
