#ifndef BSQL_TBL_H
#define BSQL_TBL_H

#include "db_bsql.h"
/* commands to interface between the SQL parser and the Typhoon DB */

/* ========================================================= COLUMNS */
struct BSQL_TMPTBL;

struct BSQL_COL {
	char *name;
	int size;
	int offset;
	struct BSQL_TMPTBL *table;
	struct BSQL_COL *next;
};

/* ========================================================= ROWS */
struct BSQL_ROW {
	char			*data;
	struct BSQL_ROW   *next;
	struct BSQL_ROW   *prev;
}

/* ========================================================= TABLES */
struct BSQL_TMPTBL {		/* intermediate table used for JOINs etc */
	int 			num_rows;
	int			row_size;
	struct BSQL_COL	*columns;
	struct BSQL_ROW	*rows;
	struct BSQL_ROW	*last;		/* last row in table */
	struct BSQL_ROW	*current;		/* current row in table */
}

struct BSQL_TBLREF {
	int type;			/* temp-table (JOIN) or typhoon table */
	union {
		struct BSQL_TMPTBL *tmptable;
		struct db_table table;
	} u;
	struct BSQL_TBLREF *next;
};

struct BSQL_COL * bsql_cols_from_dbtable( struct db_field *f );
int bsql_collist_free( struct BSQL_COL *columns ) ;
int bsql_rowlist_free( struct BSQL_ROW *rows ) ;
struct BSQL_TMPTBL * bsql_tmptbl_create( struct BSQL_COL *columns);
int bsql_tmptbl_destroy( struct BSQL_TMPTBL *table) ;
int bsql_tmptbl_add( struct BSQL_TMPTBL *t, char *row );
char * bsql_tmptbl_first( struct BSQL_TMPTBL *t) ;
char * bsql_tmptbl_next( struct BSQL_TMPTBL *t);
char * bsql_tmptbl_prev( struct BSQL_TMPTBL *t);
char * bsql_tmptbl_last( struct BSQL_TMPTBL *t);

typedef void (*BSQL_ROW_FN)( struct BSQL_TMPTBL *, char *, void * );
int bsql_tmptbl_foreach( struct BSQL_TMPTBL *t, BSQL_ROW_FN fn, void *arg );

void bsql_tmptbl_sprintrow( struct BSQL_TMPTBL *t, char *row, char *buf ) ;
char * bsql_tmptbl_tostr( struct BSQL_TMPTBL *t ) ;

/* ---------------------------------------------- support routines */
struct BSQL_COL * bsql_tmptbl_colmerge( struct BSQL_TMPTBL *t1, 
						struct BSQL_TMPTBL *t2);
char * bsql_row_merge( struct BSQL_TMPTBL *t1, struct BSQL_ROW *r1, 
					struct BSQL_TMPTBL *t2, struct BSQL_ROW *r2 );
int bsql_row_assign( char *src, struct BSQL_COL *src_col, char *dest,
		                        struct BSQL_COL *dest_col );
int bsql_tmbtbl_convert( struct BSQL_TMPTBL *t_old, struct BSQL_TMPTBL *t_new );
int bsql_tmptbl_keyoffset( struct BSQL_TMPTBL *t, char *keyname ) ;

#endif
