/* db.c : part of The Bastard disassembly environment =========================
 *
 * Contains routines for interfacing with the Typhoon database module. Typhoon
 * is pretty self-sufficient, so there will not be much here. 
 */
#include <cli/bastard_main.h>
#include <cli/parser.h>
#include <db/typhoon.h>


/* DB interpeter commands */
void db_desc_cmd(int argc, char **argv, struct COMMAND *c){
	struct db_table *table;

	if ( ! argv[0] ) {
		sys_msg("Please suppy a table name!\n");
		return;
	}
	strtoupper(argv[0], strlen( argv[0] ) +1 );
	table = db_table_by_name(NULL, argv[0]);
	if (! table ) {
		sys_msg("Table not found!\n");
		return;
	}
	db_desc_table(table);

	return;
}
void db_dump_cmd(int argc, char **argv, struct COMMAND *c){
	struct db_table *table;
	if ( ! argv[0] ) {
		sys_msg("Please suppy a table name!\n");
		return;
	}
	strtoupper(argv[0], strlen( argv[0] ) +1 );
	table = db_table_by_name(NULL, argv[0]);
	if (! table ) {
		sys_msg("Table not found!\n");
		return;
	}
	db_table_dump(table->id, '\t', '\n', stdout);
	return;
}

void db_min_cmd(int argc, char **argv, struct COMMAND *c){
	struct db_table *table;
	struct db_field *field = NULL;
	char *buf;

	if ( ! argv[0] ) {
		sys_msg("Please suppy a table name!\n");
		return;
	}
	strtoupper(argv[0], strlen( argv[0] ) +1 );
	table = db_table_by_name(NULL, argv[0]);
	if (! table ) {
		sys_msg("Table not found!\n");
		return;
	}

	buf = calloc( table->size, 1 );
	if (! buf) return;

	if ( argv[1] ) {
		/* get minimum of specified field */
		field = db_field_by_name(table, argv[1]);
		if (! field ) {
			sys_msg("Field not found!\n");
			return;
		}
		db_table_min(table, field, buf);
	} else {
		/* get first record in table */
		db_table_head(table, buf);
	}

	db_print_record( table->name, buf );
	free(buf);
	return;
}

void db_max_cmd(int argc, char **argv, struct COMMAND *c){
	struct db_table *table;
	struct db_field *field;
	char *buf;

	if ( ! argv[0] ) {
		sys_msg("Please suppy a table name!\n");
		return;
	}
	strtoupper(argv[0], strlen( argv[0] ) +1 );
	table = db_table_by_name(NULL, argv[0]);
	if (! table ) {
		sys_msg("Table not found!\n");
		return;
	}

	buf = calloc( table->size, 1 );
	if (! buf) return;

	if (  argv[1] ) {
		//strtoupper(argv[1], strlen( argv[1] ) +1 );
		field = db_field_by_name(table, argv[1]);
		if (! field ) {
			sys_msg("Field not found!\n");
			return;
		}
		db_table_max( table, field, buf );
	} else {
		db_table_foot( table, buf );
	}

	db_print_record( table->name, buf );
	free(buf);
	return;
}

void db_count_cmd(int argc, char **argv, struct COMMAND *c){
	struct db_table *table;
	if ( ! argv[0] ) {
		sys_msg("Please suppy a table name!\n");
		return;
	}
	strtoupper(argv[0], strlen( argv[0] ) +1 );
	table = db_table_by_name(NULL, argv[0]);
	if (! table ) {
		sys_msg("Table not found!\n");
		return;
	}
	printf( "\t%d\n", bdb_table_count(table->id) );
	return;
}
