#include <bastard.h>
#include <bdb.h>
#include <extension.h>


/* OUTPUT LST: Save disassembled listing of target */
int plugin_main( char *filename) {
	FILE *f;
	char *line;
	int cont;
	struct address addr;
	struct section sec;
	void *state;
	struct DISASM_TGT *target = env_get_target();
	struct DISASM_ENV *disasm_env = env_get_env();

	if (!filename)
		return (sys_set_lasterr(9010));
	f = fopen(filename, "w");
	if (!f)
		return (sys_set_lasterr(9030));
	if (!(line = calloc(2048, 1)))
		return (sys_set_lasterr(9050));

	fprintf(f, "Disassembly of %s by the bastard\n\n", target->info.name);
	fprintf(f, "%s", target->info.header);

	cont = bdb_index_first(SECTION_RVA, &sec);
	while (cont) {
		if ((cont = bdb_find_closest_next(ADDRESS_RVA, &sec.rva, &addr))) {
			fprintf(f,
				"Section: %s\tStart Address: %08X\tEnd Address: "
				"%08X\n", sec.name, sec.rva,
				sec.rva + sec.size);
			fprintf(f,
				"-----------------------------------------------"
				"--------------------------\n");
			while (cont && addr.rva < sec.rva + sec.size) {
				state = db_save_state();
				ext_sprint_code(addr.rva, line, 2048,
						disasm_env->output);
				fprintf(f, "%s\n", line);
				line[0] = '\0';
				db_restore_state(state);
				cont = bdb_index_next(ADDRESS_RVA, &addr);
			}
			fprintf(f, "\n\n");
		}
		cont = bdb_index_next(SECTION_RVA, &sec);
	}
	free(line);
	fclose(f);
	return (1);
}
