#ifndef SOB_ASM_WIN_H
#define SOB_ASM_WIN_H

#include <gtk/gtk.h>

/* we need:
   1) a printf() function that will parse the bastard asmsprintf into the
	   appropriate type and field, and will arrange/preprocess operands in
		proper assembler order
	2) a routine that takes these fields and injects them into a text widget
	   with the user-defined fonts and colors
	3) some way of controlling field length
*/

struct ASMCODE_LINE {
	char *addr;
	char *bytes;
	char *inst;
	char *m1;
	char *m2;
	char *m3;
};

struct ASMDATA_LINE {	
	char *addr;
};

struct ASMFUNC_LINE {	
	char *addr;
};

struct ASMLABL_LINE {	
	char *addr;
};

struct ASMCMNT_LINE {	
	char *addr;
};

/* maybe move these into sob_ui.h ? */
struct DISP_LINE {
	int type;
	unsigned long rva;				/* addr this line is tied to */
	char *text;
	union {
		struct ASMCODE_LINE code;
		struct ASMDATA_LINE data;
		struct ASMFUNC_LINE func;
		struct ASMLABL_LINE label;
		struct ASMCMNT_LINE cmt;	
	} u;
	struct DISP_LINE *next;
};

struct DISP_BUFFER {
	int size; 			/* # lines in buffer: user-configured */
	int line_size;		/* # of chars in a line */
	int base;		   /* line containing load_display_buf rva */ 
	long start;			/* starting rva of buffer */
	long end;			/* ending rva of buffer */
	struct DISP_LINE *lines;
};

struct DISPLAY {
	int size;
	int start, end;   /* buffer indexes of first, last line */
	int current;		/* display index of current line */
	int init;
	int upper, lower; /* upper/lower sb bounds */
	float x, y;			/* saved X and Y co-ords: Gtk doesn't do this ;( */
	struct DISP_BUFFER buf;
};


void init_asm_win();
void free_asm_disp_buffer();
int load_asm_win_buf(long addr);
int config_asm_win(int start);
void init_asm_display(void);
void calc_asm_win_size();
void init_asm_win(void);
void cb_hscroll_asmwin(GtkAdjustment *adj, float *data);
void cb_vscroll_asmwin(GtkAdjustment *adj, float *data);
#endif
