#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <bastard.h>

#include "sob_bastard.h"
#include "sob_extensions.h"
#include "sob_ui.h"
#include "sob_help_win.h"	




/* goddamn global widget pointers */
GtkWidget *about_dlg = NULL, 
          *select_file_dlg = NULL,
		  *asm_win_popup = NULL,
		  *select_font_dlg = NULL,
		  *db_query_dlg = NULL,
		  *settings_dlg = NULL,
		  *color_dlg = NULL,
		  *saveas_dlg = NULL,
		  *mbox_dlg = NULL,
		  *find_dlg = NULL,
		  *mod_addr_dlg = NULL,
		  *mod_inst_dlg = NULL,
		  *mod_int_dlg = NULL,
		  *mod_func_dlg = NULL,
		  *mod_struct_dlg = NULL,
		  *mod_sec_dlg = NULL,
		  *new_dtype_dlg = NULL,
		  *new_const_dlg = NULL,
		  *tgt_struct_dlg = NULL,
		  *tgt_dtype_val_dlg = NULL;
		  


/* ----------------------------------------------------------------- */
void
on_load_target1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{  
   //if (load_file_dlg.self == NULL) {
   //    load_file_dlg.self = create_LoadFileDlg(); 
   //    init_load_file_dlg();
   //}

   gtk_widget_show(load_file_dlg.self);
}


void
on_load_bdb1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	/* show load dialog */
}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   /* Save DB */
	target_save_db();
}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	/* show save as dialog */
}


void
on_close1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	struct DISASM_ENV *d_env = env_get_env();
		
	if ( (is_target_mod() || d_env->flags & DB_MOD) && !  is_target_saved() ) {
		/*prompt for save */
	}
	
   /* Close DB */
	target_close_db();
   /* Reset UI */
	reset_ui_main();
	return;
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   sys_quit();
   env_set_flag( QUIT_NOW );
   exit(0);
}


void
on_edit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_find1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(find_dlg);

}


void
on_settings1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(settings_dlg);

}


void
on_refresh_asm1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	unsigned long start = load_win_buf(&asm_display, target_entry());
	printf( "refreshing asm entry: %08X start: %08X\n", target_entry(), start);
	config_win( &asm_display, start );
}


void
on_refesh_names1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	RefreshNames();
}


void
on_refresh_functions1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	RefreshFunctions();
}


void
on_refresh_strings1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	RefreshStrings();
}


void
on_refresh_sections1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	RefreshSections();
}


void
on_refresh_imports1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	RefreshImports();
}


void
on_help1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_SOB_PAGE );
}


void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   /* call about dialog */
   if (about_dlg == NULL)
      about_dlg = create_AboutDlg();
   gtk_widget_show(about_dlg);

}


void
on_LoadFileDlg_show                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
   return;

}


void
loadfile_browse_ok                      (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_entry_set_text(
         GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_file_entry")), 
         gtk_file_selection_get_filename((GtkFileSelection *)select_file_dlg)                 );
   gtk_widget_hide(select_file_dlg);

   return;
}

void
loadfile_dlg_browse                    (GtkButton       *button,
                                        gpointer         user_data)
{
   /* show file sel dialog */
   if (select_file_dlg == NULL) 
      select_file_dlg = create_SelectFileDlg(); 

   //gtk_file_selection_show_fileop_buttons(select_file_dlg);
   gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (
               select_file_dlg)->ok_button), "clicked", 
         (GtkSignalFunc) loadfile_browse_ok, select_file_dlg );
   gtk_widget_show(select_file_dlg);
   return;
}


void
loadfile_dlg_format_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
   GtkEntry *entry;
   char filename[PATH_MAX];
   
   entry = GTK_ENTRY(lookup_widget(load_file_dlg.self, "lfd_format_entry")); 

   /* create options based on .dat file */
   sprintf(filename, "%s/formats/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename,  &load_file_dlg.format);

   /* here's how you make dynamic widgets :P */
   /*
   label = gtk_label_new(format);
   gtk_widget_set_name(label, "fmtlabel");
   gtk_box_pack_start(vbox13, label, TRUE, FALSE, 0);
   gtk_widget_show(label);
   */
   return;

}


void
loadfile_dlg_cpu_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   GtkEntry *entry;
   char filename[PATH_MAX];
   
   entry = GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_cpu_entry")); 

   /* create options based on .dat file */
   sprintf(filename, "%s/arch/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename, &load_file_dlg.cpu);
   return;
}

void loadfile_ok_foreach(GtkWidget *widget, gpointer data) {
   int val, *option = data;
   
   if ( (val = (int) gtk_object_get_data(GTK_OBJECT(widget), "value")) &&
         gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(widget) )) {
      /* OR option with value for checkbox/radio button */
      *option |= val;
   } 
   return;
}

void
loadfile_dlg_ok                        (GtkButton       *button,
                                        gpointer         user_data)
{
   struct stat s;
   GtkVBox *vbox;
   GList *children, *ptr;
   int x, option = 0;

   GtkEntry *entry; 
   
   gtk_widget_hide(load_file_dlg.self);

   /* fill struct with target, extensions, options */
   entry =  GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_file_entry")); 
   sob_load_settings.filename =  gtk_entry_get_text(entry);
   if (stat( sob_load_settings.filename, &s) ) { 
      /* error! file does not exist! */
      printf("Error %X: cannot load file '%s'\n", errno, 
            sob_load_settings.filename);
      gtk_widget_show(load_file_dlg.self);
      return;
   }
   
   /* disassembly options */
   children = load_file_dlg.disasm.box->box.children;
   for ( x = 0; (ptr = g_list_nth(children, x)); x++) {
      char *val;
      GtkBoxChild *child = g_list_nth_data(children, x);//ptr->data;
      GtkWidget *widget = child->widget;
      if ( (val = (char *) gtk_object_get_data(GTK_OBJECT(widget), "value")) &&
         gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(widget) )) {
            sob_load_settings.disasm_method = val;
      }
   } 
   
   
   /* format options */
   gtk_container_foreach((GtkContainer *)load_file_dlg.format.box, 
                           loadfile_ok_foreach, &option);

   sob_load_settings.format =  gtk_entry_get_text(
           GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_format_entry")) );
   sob_load_settings.format_options = option;
   option = 0;

   /* cpu options */
   gtk_container_foreach((GtkContainer *)load_file_dlg.cpu.box, 
                           loadfile_ok_foreach, &option);
   sob_load_settings.cpu =  gtk_entry_get_text(
           GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_cpu_entry")) );
   sob_load_settings.cpu_options = option;
   option = 0;

   /* asm options */
   gtk_container_foreach((GtkContainer *)load_file_dlg.asmblr.box, 
                           loadfile_ok_foreach, &option);
   sob_load_settings.asmblr =  gtk_entry_get_text(
           GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_asm_entry")) );
   sob_load_settings.asm_options = option;
   option = 0;

   /* hll options */
   gtk_container_foreach((GtkContainer *)load_file_dlg.hll.box, 
                           loadfile_ok_foreach, &option);
   sob_load_settings.hll =  gtk_entry_get_text(
           GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_hll_entry")) );
   sob_load_settings.hll_options = option;
   option = 0;

   load_and_disasm_target(&sob_load_settings);
   gtk_entry_set_text( entry, "");

   return;
}


void
selectfile_dlg_ok                      (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(select_file_dlg);

   return;
}


void
loadfile_dlg_cancel                    (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(load_file_dlg.self);
   gtk_entry_set_text(
         GTK_ENTRY(lookup_widget( load_file_dlg.self, "lfd_file_entry")), 
         ""  );
   return;
}


void
selectfile_dlg_cancel                  (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(select_file_dlg);
   return;
}


void
loadfile_dlg_asm_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   char filename[PATH_MAX];
   GtkEntry *entry = 
      GTK_ENTRY(lookup_widget(load_file_dlg.self, "lfd_asm_entry")); 
	

   /* create options based on .dat file */
   sprintf(filename, "%s/asm/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename, &load_file_dlg.asmblr);
   return;
}


void
loadfile_dlg_hll_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   char filename[PATH_MAX];
   GtkEntry *entry = 
      GTK_ENTRY(lookup_widget(load_file_dlg.self, "lfd_hll_entry")); 

   /* create options based on .dat file */
   sprintf(filename, "%s/lang/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename, &load_file_dlg.hll);
   return;

}

void loadfile_dlg_comp_activate(GtkEditable     *editable, gpointer         user_data){
   char filename[PATH_MAX];
   GtkEntry *entry = 
      GTK_ENTRY(lookup_widget(load_file_dlg.self, "lfd_comp_entry")); 

   /* create options based on .dat file */
   sprintf(filename, "%s/comp/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename, &load_file_dlg.comp);
   return;
}

void loadfile_dlg_os_activate(GtkEditable     *editable, gpointer         user_data){
   char filename[PATH_MAX];
   GtkEntry *entry = 
      GTK_ENTRY(lookup_widget(load_file_dlg.self, "lfd_os_entry")); 

   /* create options based on .dat file */
   sprintf(filename, "%s/os/%s.dat", env_get_home(), 
         gtk_entry_get_text(entry));

   create_dlg_from_datfile( filename, &load_file_dlg.os);
   return;
}
void
on_bastard_howto1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_HOWTO_PAGE );
}


void
on_bastard_manual1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_MANUAL_PAGE );
}


void
on_api_reference1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_API_PAGE );

}


void
on_db_schema1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_DB_PAGE );

}


void
on_scripting_manual1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_BC_PAGE );
}

void
opentgt_release_event                  (GtkButton       *button,
                                                 gpointer         user_data)
{
   on_load_target1_activate(NULL,  user_data);

  return;
}


void
saveas_asm_ok                      (GtkButton       *button,
                                        gpointer         user_data)
{
   char *filename;

   filename = gtk_file_selection_get_filename((GtkFileSelection *)select_file_dlg);
   if (filename[0]) 
      target_save_lst( filename );
   gtk_widget_hide(select_file_dlg);

   return;
}

void
on_saveas_asm_file1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   char *filename;

   if (select_file_dlg == NULL) {
      select_file_dlg = create_SelectFileDlg(); 
   }

   if (sob_load_settings.filename[0]) {
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (
            select_file_dlg)->ok_button), "clicked", 
            (GtkSignalFunc) saveas_asm_ok, select_file_dlg );
      gtk_widget_show(select_file_dlg);
   }
}


void
saveas_lst_ok                      (GtkButton       *button,
                                        gpointer         user_data)
{
   char *filename;

   filename = gtk_file_selection_get_filename( (GtkFileSelection *)select_file_dlg);
   if (filename[0]) 
      target_save_lst( filename );
   gtk_widget_hide(select_file_dlg);

   return;
}

void
on_saveas_lst_file1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   if (select_file_dlg == NULL) {
      select_file_dlg = create_SelectFileDlg(); 
   }

   if (sob_load_settings.filename[0]) {
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (
            select_file_dlg)->ok_button), "clicked", 
            (GtkSignalFunc) saveas_lst_ok, select_file_dlg );
      gtk_widget_show(select_file_dlg);
   }
}




void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_edit_settings1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(settings_dlg);

}


void
on_edit_font1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_findtext1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(find_dlg);

}


void
on_find_mnemonic1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(find_dlg);

}


void
on_find_operand1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(find_dlg);

}


void
on_findbytes1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(find_dlg);

}

unsigned long get_rva_of_current_line(GtkText *t) {
}

int get_bytes_in_selections( GtkText *t, char *buf, int len) {
}

unsigned long get_rva_in_selection(GtkText *t) {
	/* GList *current_line; // Data is a LineParam
	   int cursor_pos_x, cursor_pos_y
	GtkPropertyMark cursor_mark; // .index
	*/
	/* struct GtkEditable {
  guint      current_pos;

  guint      selection_start_pos;
  guint      selection_end_pos;
  guint      has_selection : 1;
}; */
}

void
on_jump_to_address1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	printf("jump to addr ? \n");

}


void
on_disassemble_from_here1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	printf("disassemble from ?\n");

}


void
on_sob_help1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	sob_help_show( HELP_SOB_PAGE );
}





void
on_script_exec_released                (GtkButton       *button,
                                        gpointer         user_data)
{
	int fd;
	GtkEditable *text;
	char tempname[PATH_MAX], *script;
	struct DISASM_ENV *d_env = env_get_env();
	
	sprintf( tempname, "%s/.sob_tmp.bc.XXXXXX", d_env->dbpath );
	fd = mkstemp( tempname );
	
	if ( fd > 0 ) {
		text = (GtkEditable *)lookup_widget( sob_main_window, "MacroEditor");
		/* save text contents as temp file */
		script = (char *)gtk_editable_get_chars( text, 0, -1);
		write( fd, script, strlen(script) );
	
		/* execute temp file */
		script_file_exec( tempname );
		
		/* remove temp file */
		close(fd);
		free(script);
	}
	unlink(tempname);
	return;
}


void
on_script_open_released                (GtkButton       *button,
                                        gpointer         user_data)
{
	/* save fname */
	/* while fgets, gtk_text_insert */
}


void
on_script_save_released                (GtkButton       *button,
                                        gpointer         user_data)
{
	/* if ! fname, prompt */
	/* same as macro-exec */
}


void
on_script_api_help_released            (GtkButton       *button,
                                        gpointer         user_data)
{
	on_api_reference1_activate(NULL,user_data);
}


void
on_script_db_help_released             (GtkButton       *button,
                                        gpointer         user_data)
{
	on_db_schema1_activate(NULL, user_data);
}


void
on_script_script_help_released         (GtkButton       *button,
                                        gpointer         user_data)
{
	on_scripting_manual1_activate(NULL, user_data);
}


void
on_notes_open_released                 (GtkButton       *button,
                                        gpointer         user_data)
{
	/* open file */
	/* while fgets, gtk_text_insert */
	/* close file */
}


void
on_notes_save_released                 (GtkButton       *button,
                                        gpointer         user_data)
{
	/* prompt for filename [save this! ... if ! fname,... ]
	/* do same as macro_exec to write */

}


void
on_notes_clear_released                (GtkButton       *button,
                                        gpointer         user_data)
{
	/* disp_clear */
	/* delete notes->fname */
}


void
on_notes_dump_lst_released             (GtkButton       *button,
                                        gpointer         user_data)
{
	/* while (sprint_address) gtk_text_insert */
}


void
on_about_ok_released                   (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide( (GtkWidget *) about_dlg );
}

void
on_Console_STDIN_activate              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	char *buf = gtk_entry_get_text( (GtkEntry *) editable);
	fwrite( buf, strlen(buf), 1, stdin );
}


void
on_modify_address_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(mod_addr_dlg);

}


void
on_modify_instruction_menu_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(mod_inst_dlg);

}


void
on_modify_function_menu_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(mod_func_dlg);

}


void
on_modify_section_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(mod_sec_dlg);

}


void
on_data_types_and_values_menuitem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_widget_show(tgt_dtype_val_dlg);

}


void
on_program_structure_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{	
	gtk_widget_show(tgt_struct_dlg);
}


gboolean
on_AsmView_button_release_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GdkEventButton *bevent;
	if (event->type == GDK_BUTTON_RELEASE) {
		bevent = (GdkEventButton *) event; 
		gtk_menu_popup (GTK_MENU(asm_win_popup), NULL, NULL, NULL, NULL,
                         bevent->button, bevent->time);
		return TRUE;
	}
	return FALSE;
}


void
on_find_win_find_button_released       (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_modify_addr_win_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_mod_addr_rva_entry_activate         (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_mod_addr_code_radio_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_mod_addr_data_radio_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_mod_addr_ok_button_released         (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_addr_dlg);

}


void
on_mod_addr_cancel_button_released     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_addr_dlg);

}


void
on_modify_inst_win_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_mod_inst_ok_button_released         (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_inst_dlg);

}


void
on_data_types_values_win_show          (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_data_types_values_done_button_released
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(tgt_dtype_val_dlg);

}


void
on_mod_func_param_list_selection_changed
                                        (GtkList         *list,
                                        gpointer         user_data)
{

}



void
on_mod_func_param_delete_button_released
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_func_local_list_selection_changed
                                        (GtkList         *list,
                                        gpointer         user_data)
{

}


void
on_mod_func_local_new_button_released  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_func_local_delete_button_released
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_func_ok_button_released         (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_func_dlg);

}


void
on_mod_struct_field_new_button_released
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_struct_field_delete_button_released
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_struct_ok_button_released       (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_struct_dlg);

}


void
on_new_dtype_ok_button_released        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(new_dtype_dlg);
}


void
on_new_dtype_cancel_button_released    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(new_dtype_dlg);
}


void
on_new_const_ok_button_released        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(new_const_dlg);

}


void
on_new_const_cancel_button_released    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(new_const_dlg);

}


void
on_mod_sec_ok_button_released          (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_sec_dlg);
}


void
on_cut2_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_copy2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_find2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show(find_dlg);	

}


void
on_show_datatypes_values_menu_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show(tgt_dtype_val_dlg);	
}



void
on_mbox_no_button_released             (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mbox_dlg);

}


void
on_mbox_yes_button_released            (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mbox_dlg);

}


void
on_find_wind_cancel_button_released    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(find_dlg);

}


void
on_mod_inst_cancel_button_released     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_inst_dlg);

}


void
on_button60_released                   (GtkButton       *button,
                                        gpointer         user_data)
{
	
}


void
on_mod_func_cancel_button_released     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_func_dlg);

}


void
on_mod_struct_cancel_button_released   (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_struct_dlg);

}


void
on_mod_sec_cancel_button_released      (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(mod_sec_dlg);

}


void
on_tgt_struct_done_button_released     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(tgt_struct_dlg);
}


void
on_mos_func_param_new_button_released  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mod_sec_win_show                    (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_tgt_struct_win_show                 (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

