#include <stdio.h>

#include <bastard.h>

#include "sob_bastard.h"
#include "sob_misc_win.h"
#include "sob_ui.h"

struct SOB_LOAD_SETTINGS sob_load_settings = {0};

int load_and_disasm_target (struct SOB_LOAD_SETTINGS *s){
	struct DISASM_ENV *disasm_env = env_get_env();
	struct DISASM_TGT *target = env_get_target();
	GtkNotebook *nbook = (GtkNotebook *)lookup_widget(sob_main_window, "MainAppTab");

	/* set active page to console */
	gtk_notebook_set_page(nbook, 14);
	
	/* temporary debugging code */
	printf("filename %s \n disasm_method %s\n"
			  "format %s : %08X\n"
			  "cpu %s : %08X\n"
			  "asm %s : %08X\n"
			  "hll %s : %08X\n",
					s->filename, s->disasm_method, s->format, s->format_options,
					s->cpu, s->cpu_options, s->asmblr, s->asm_options,
					s->hll, s->hll_options);
	/* if loaded sob_close_target(); */
	
   /* Load Target */
	target_load(s->filename);
   /* Set Target File format */
	target_set_format(s->format, s->format_options);
   /* Set Target CPU */
	target_set_arch(s->cpu, s->cpu_options);
   /* Set Target Assembler */
	target_set_asm(s->asmblr, s->asm_options);
   /* Set Target HLL */
	target_set_lang(s->hll, s->hll_options);
	
			
   /* do Disassemble method */

	disasm_target(s->disasm_method, NULL ); /* hmm must add support for param */
	
	/* OK, target is disassembled, now update the UI */
	FillSections();
	FillNames();
	FillFunctions();
	FillImports();
	FillStrings();
	FillHeader(target_header());
	
	/* OK, display the friggin asm file! */
	config_win( &asm_display, load_win_buf(&asm_display, target_entry()) );
	gtk_notebook_set_page(nbook, 0);
	
	printf("debug: doing display int_code\n");
	config_win( &int_display, load_win_buf(&int_display, 1));

   return(1);
}
