#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <bastard.h>

#include "support.h"
#include "sob_cfg.h"
#include "sob_ui_prefs.h"

struct SOB_ENV_ITEM sob_env[] = {
	{ 0, "target_mod"},
	{ 0, "target_saved"},
	{ 0, "config_mod"}
};

struct SOB_CFG_ITEM sob_cfg[] = {
	{ "ui_prefs", read_ui_prefs, write_ui_prefs, {{0}} },
	{ NULL }
};

int process_sob_cfg_file( char *path ){
	return(1);
}

int read_sob_cfg() {
	return(1);
}

int write_sob_cfg(){
	return(1);
}

int get_sob_env( int id ) {
	if ( id > SOBENV_CFGMOD ) return(-1);
	return( sob_env[id].value );
}

int set_sob_env( int id, int val ){
	if ( id > SOBENV_CFGMOD ) return(-1);
	sob_env[id].value = val;
	return(1);
}

int get_sob_env_byname( char *name ) {
	int x;
	
	for ( x = 0; x <= SOBENV_CFGMOD; x++ ) {
		if (! strcmp( sob_env[x].name, name ) ) 
			return( sob_env[x].value );
	}
	return(-1);
}

int set_sob_env_byname( char *name, int val ){
	int x;
	
	for ( x = 0; x <= SOBENV_CFGMOD; x++ ) {
		if (! strcmp( sob_env[x].name, name ) ) {
			sob_env[x].value = val;
			return(1);
		}
	}
	return(-1);
}