
#include <stdio.h>
#include <stdlib.h>
#include <bastard.h>
#include <bdb.h>

#include "sob_ui.h"
#include "support.h"
#include "sob_int_win.h"
#include "sob_ui_prefs.h"

void int_display_fill(struct DISPLAY *d, GtkText *t, struct DISP_LINE *line);

struct DISPLAY int_display = { "IntView", "IntHScroll", "IntVScroll", 
								cb_hscroll_intwin, cb_vscroll_intwin, 
								INT_CODE_ID, int_display_addline, int_display_fill,
								int_display_total, 0		};

int int_display_total(struct DISPLAY *d){
	return( bdb_table_count(INT_CODE) );
}

void int_display_fill(struct DISPLAY *d, GtkText *t, struct DISP_LINE *line){
	int pos;
	struct INTDIR_LINE *dir;
	struct INTCODE_LINE *code;
	struct INTDATA_LINE *data;
	struct INTFUNC_LINE *func;
	struct INTCMNT_LINE *cmt;
	
	pos = gtk_text_get_point(t);
	
	switch ( line->type ) {
		case INTDIR:
			dir = &line->u.idir;
			disp_fill_to_pos( t, pos, INTCODE_POS(idir_pos) );
			gtk_text_insert( t, INTCODE_FONT(idir_font), INTCODE_COLOR(idir_fg), 
							INTCODE_COLOR(idir_bg), dir->dir, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), " {", 2 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), dir->args, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), "}", 1 );
			break;
		case INTCODE:
			code = &line->u.icode;
			disp_fill_to_pos( t, pos, INTCODE_POS(imnem_pos) );
			gtk_text_insert( t, INTCODE_FONT(imnem_font), INTCODE_COLOR(imnem_fg), 
							INTCODE_COLOR(imnem_bg), code->mnemonic, -1 );
		
			disp_fill_to_pos( t, pos, code->src_pos );
			gtk_text_insert( t, code->src_font.font, code->src_font.fgcolor, 
							code->src_font.bgcolor, code->src, -1 );
			if ( code->arg_pos ) {
				gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), ", ", 2 );
				disp_fill_to_pos( t, pos, code->arg_pos );
				gtk_text_insert( t, code->arg_font.font, code->arg_font.fgcolor, 
								code->arg_font.bgcolor, code->arg, -1 );
			}
			if ( code->dest_pos) {
				gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
					SOB_COLOR(f_bgcolor), ", ", 2 );
				disp_fill_to_pos( t, pos, code->dest_pos );
				gtk_text_insert( t, code->dest_font.font, code->dest_font.fgcolor, 
								code->dest_font.bgcolor, code->dest, -1 );
			}
			break;
		case INTFUNC:
			func = &line->u.ifunc;
			disp_fill_to_pos( t, pos, INTCODE_POS(idir_pos));
			gtk_text_insert( t, INTCODE_FONT(imnem_font), INTCODE_COLOR(imnem_fg), 
								INTCODE_COLOR(imnem_bg), func->ret, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), " ", 1 );
			gtk_text_insert( t, NAME_FONT(n_sub_font), NAME_COLOR(n_sub_fg), 
								NAME_COLOR(n_sub_fg), func->name, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), "( ", 2 );
			gtk_text_insert( t, NAME_FONT(n_sub_font), NAME_COLOR(n_sub_fg), 
								NAME_COLOR(n_sub_fg), func->args, -1 );
			gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), " )", 2 );
			
			break;
		case INTCOMMENT:
			cmt = &line->u.icmt;
			disp_fill_to_pos( t, pos, CMT_POS(cmt_pos));
			gtk_text_insert( t, CMT_FONT(cmt_user_font), CMT_COLOR(cmt_user_fg), 
								CMT_COLOR(cmt_user_fg), cmt->text, -1 );
			break;
		case INTDATA:
		default:
			break;
	}
	gtk_text_insert( t, SOB_FONT(f_fixed_regular), SOB_COLOR(f_fgcolor),
								SOB_COLOR(f_bgcolor), "\n", -1 );
	return;
}

void int_add_funcline( struct DISP_LINE *line, struct int_code *i, struct function *f ) {
	struct INTFUNC_LINE *func;
	struct name n;
	struct data_type t;

	line->addr = i->id;
	line->type = INTFUNC;
	
	func = &line->u.ifunc;
	memset( func, 0, sizeof(struct INTFUNC_LINE) );
	if ( bdb_index_find( NAME_RVA, &f->rva, &n ) ) {
		strncpy( func->name, n.text, 63 );
	}
	
	if ( f->ret_type ) {
		bdb_index_find( DATA_TYPE_ID, &f->ret_type, &t );
	} else {
		bdb_index_first( DATA_TYPE_ID, &t );	/* use default */
	}
	strncpy( func->ret, t.name, 15 );
	
	/* TODO: args */
	
	return;
}

void int_add_dirline( struct DISP_LINE *line, struct int_code *i ) {
	struct INTDIR_LINE *dir;
	line->addr = i->id;
	line->type = INTDIR;
	
	dir = &line->u.idir;
	memset( dir, 0, sizeof(struct INTDIR_LINE) );
	intcode_getstr_mnem( i->opcode, dir->dir, 32 );
	intcode_sprint_dirop( i, dir->args, 128 );
	return;
}

void int_op_font(int type,  struct FONT_PREF *font) {
	switch (type & 0x000000FF) {
		case op_greg:
		case op_ireg:
		case op_lreg:
		case op_rreg:
		case op_specreg:
		case op_scratch:
			font->font = INTCODE_FONT(ireg_font);
			font->fgcolor = INTCODE_COLOR(ireg_fg);
			font->bgcolor = INTCODE_COLOR(ireg_bg);
			break;
		case op_label:
			font->font = NAME_FONT(n_user_font);
			font->fgcolor = NAME_COLOR(n_user_fg);
			font->bgcolor = NAME_COLOR(n_user_bg);
			break;
		case op_imm:
		default:
			font->font = INTCODE_FONT(iimm_font);
			font->fgcolor = INTCODE_COLOR(iimm_fg);
			font->bgcolor = INTCODE_COLOR(iimm_bg);
	}
	return;
}

void int_add_codeline( struct DISP_LINE *line, struct int_code *i ) {
	struct INTCODE_LINE *code;
	int op_pos;
		
	line->addr = i->id;
	line->type = INTCODE;
	
	code = &line->u.icode;
	memset( code, 0, sizeof(struct INTCODE_LINE) );
	
	sprintf( code->order, "%d", i->order );
	intcode_getstr_mnem( i->opcode, code->mnemonic, 32 );
	code->mnem_pos = INTCODE_POS(imnem_pos);
	
	op_pos = INTCODE_POS(iop_pos);
	if ( i->sType) { 
		code->src_pos = op_pos;
		int_op_font(i->sType, &code->src_font);
		intcode_sprint_op( i->src, i->sType, code->src, 64);
		op_pos += strlen(code->src);
	}
	if ( i->aType) {
		code->arg_pos = op_pos; 
		int_op_font(i->aType, &code->arg_font);
		intcode_sprint_op( i->arg, i->aType, code->arg, 64);
		op_pos += strlen(code->arg);
	}
	if ( i->dType) {
		code->dest_pos = op_pos;
		int_op_font(i->dType, &code->dest_font); 
		intcode_sprint_op( i->dest, i->dType, code->dest, 64);
		op_pos += strlen(code->dest);
	}
	return;
}

void int_add_cmtline( struct DISP_LINE *line, struct int_code *i, struct comment *c ) {
	struct INTCMNT_LINE *cmt;
		
	line->addr = i->id;
	line->type = INTCOMMENT;
	
	cmt = &line->u.icmt;
	memset( cmt, 0, sizeof(struct INTCMNT_LINE) );
	strcpy( cmt->text, c->text );
	return;
}

void int_display_addline( struct DISPLAY *d, int *x, struct int_code *i ) {
	struct comment cmt;
	struct function f;
		
	if ( (i->opcode & 0xFF000000) == EXT_ISA ) { 
		if (i->opcode & 0x00FF0000 == i_proc && bdb_index_find(FUNCTION_ID, &i->func, &f) ) {
			int_add_funcline( &d->buf.lines[(*x)++], i, &f );
			if ( *x >=d->buf.size )  return;
		}
		int_add_dirline( &d->buf.lines[(*x)++], i );
		if ( *x >=d->buf.size )  return;
	} else if ( (i->opcode & 0xFF000000) == BASE_ISA ) {
		int_add_codeline( &d->buf.lines[(*x)++], i );
		if ( *x >=d->buf.size )  return;
		
	} 
	if ( i->comment && bdb_index_find( COMMENT_ID, &i->comment, &cmt ) ){
		int_add_cmtline( &d->buf.lines[(*x)++], i, &cmt );
		if ( *x >=d->buf.size )  return;
	}
	(*x)--;	/* normalize */
	return;
}

void cb_hscroll_intwin(GtkAdjustment *adj, float *data){	
	*data = adj->value;
}

void cb_vscroll_intwin(GtkAdjustment *adj, float *data){
	int old, new; /* convert moronic floats to sensible integers */
		
	if (! int_display.init) return;
	old = *data;
	new = adj->value;
	*data = adj->value;
	/* deal with scrollbar action : send old & new positions */
	update_win(&int_display, old, new);
}
