
#ifndef SOB_INT_WIN_H
#define SOB_INT_WIN_H

#include <gtk/gtk.h>
#include <bdb.h>

struct INTDIR_LINE {
	char dir[32];
	char args[128];
};

struct INTCODE_LINE {
	char order[8];
	int mnem_pos;
	char mnemonic[32];
	struct FONT_PREF src_font;
	int src_pos;
	char src [64];
	struct FONT_PREF arg_font;
	int arg_pos;
	char arg [64];
	struct FONT_PREF dest_font;
	int dest_pos;
	char dest [64];
};

struct INTDATA_LINE {
	char type[16];
	char name[64];
	char val[16];	/* constant/init value */
};

struct INTFUNC_LINE {
	char ret[16];
	char name[64];
	char args[256];
};

struct INTCMNT_LINE {
	char text[256];
};

struct DISPLAY;
			
void int_display_addline( struct DISPLAY *d, int *x, struct int_code *i );
int int_display_total(struct DISPLAY *d);
void cb_hscroll_intwin(GtkAdjustment *adj, float *data);
void cb_vscroll_intwin(GtkAdjustment *adj, float *data);

#endif