#ifndef SOB_UI_PREFS_H
#define SOB_UI_PREFS_H

#include <gtk/gtk.h>
#include "sob_cfg.h"

struct FONT_PREF {
	GdkFont *font;
	GdkColor *fgcolor;
	GdkColor *bgcolor;
};

struct USER_UI_PREFS {
	struct SOB_CFG_ITEM *code;
	struct SOB_CFG_ITEM *data;
	struct SOB_CFG_ITEM *xref;
	struct SOB_CFG_ITEM *cmt;
	struct SOB_CFG_ITEM *name;
	struct SOB_CFG_ITEM *intcode;
	struct SOB_CFG_ITEM *fincode;
	struct SOB_CFG_ITEM *fonts;
};

extern struct USER_UI_PREFS prefs;

/* these enums represent offsets into the appropriate array of SOB_CFG_ITEMs */
enum code_prefs { addr_pos, addr_font, addr_fg, addr_bg, hex_pos, hex_num, hex_font, hex_fg, hex_bg, 
					mnem_pos, mnem_font, mnem_fg, mnem_bg, op_pos, reg_font, reg_fg, reg_bg, 
					imm_font, imm_fg, imm_bg, mem_font, mem_fg, mem_bg, expr_font, expr_fg, expr_bg };
enum data_prefs { d_addr_pos, d_addr_font, d_addr_fg, d_addr_bg, d_hex_pos, d_hex_font, d_hex_fg, d_hex_bg,	
				ascii_pos, ascii_font, ascii_fg, ascii_bg, string_pos, string_font, string_fg, string_bg };	
enum xref_prefs { xref_pos, xref_from_font, xref_from_fg, xref_from_bg, xref_to_font, xref_to_fg, xref_to_bg };
enum cmt_prefs { cmt_pos, cmt_auto_font, cmt_auto_fg, cmt_auto_bg, cmt_user_font, cmt_user_fg, cmt_user_bg };
enum name_prefs { n_auto_font, n_auto_fg, n_auto_bg, n_user_font, n_user_fg, n_user_bg,
					n_symbol_font, n_symbol_fg, n_symbol_bg, n_sub_font, n_sub_fg, n_sub_bg,
					n_struct_font, n_struct_fg, n_struct_bg, n_import_font, n_import_fg, n_import_bg,
					n_export_font, n_export_fg, n_export_bg , n_sec_font, n_sec_fg, n_sec_bg };
enum intcode_prefs { imnem_pos, imnem_font, imnem_fg, imnem_bg, idir_pos, idir_font, idir_fg, idir_bg,
					iop_pos, ireg_font, ireg_fg, ireg_bg, iimm_font, iimm_fg, iimm_bg };
enum fincode_prefs { fcode_pos, fcode_font, fcode_fg, fcode_bg };
enum fonts_prefs { f_fixed_regular, f_fixed_bold, f_fixed_italic, f_var_regular, f_var_bold, f_bvar_italic,
					f_fgcolor, f_bgcolor, f_errcolor};

					
#define CODE_COLOR(x) &prefs.code[x].data.color
#define CODE_FONT(x) *prefs.code[x].data.font
#define CODE_POS(x) prefs.code[x].data.i
					
#define DATA_COLOR(x) &prefs.data[x].data.color
#define DATA_FONT(x) *prefs.data[x].data.font
#define DATA_POS(x) prefs.data[x].data.i
					
#define XREF_COLOR(x) &prefs.xref[x].data.color
#define XREF_FONT(x) *prefs.xref[x].data.font
#define XREF_POS(x) prefs.xref[x].data.i

#define NAME_COLOR(x) &prefs.name[x].data.color
#define NAME_FONT(x) *prefs.name[x].data.font
#define NAME_POS(x) prefs.name[x].data.i

#define CMT_COLOR(x) &prefs.cmt[x].data.color
#define CMT_FONT(x) *prefs.cmt[x].data.font
#define CMT_POS(x) prefs.cmt[x].data.i

#define INTCODE_COLOR(x) &prefs.intcode[x].data.color
#define INTCODE_FONT(x) *prefs.intcode[x].data.font
#define INTCODE_POS(x) prefs.intcode[x].data.i

#define FINCODE_COLOR(x) &prefs.fincode[x].data.color
#define FINCODE_FONT(x) *prefs.fincode[x].data.font
#define FINCODE_POS(x) prefs.fincode[x].data.i

#define SOB_COLOR(x) &prefs.fonts[x].data.color
#define SOB_FONT(x) *prefs.fonts[x].data.font
					

int init_ui_prefs();
				

void read_ui_prefs( struct SOB_CFG_ITEM *item, char *line );
void write_ui_prefs( struct SOB_CFG_ITEM *item, char *buf, int len );
	
void read_uipref_section( struct SOB_CFG_ITEM *item, char *line );
void write_uipref_section( struct SOB_CFG_ITEM *item, char *buf, int len );
	
void read_gdkcolor(struct SOB_CFG_ITEM *item, char *line);
void write_gdkcolor(struct SOB_CFG_ITEM *item, char *buf, int len );
void read_font(struct SOB_CFG_ITEM *item, char *line );
void write_font(struct SOB_CFG_ITEM *item, char *buf, int len);
void read_int(struct SOB_CFG_ITEM *item, char *line);
void write_int(struct SOB_CFG_ITEM *item, char *buf, int len);
					
/* config item handlers */

					
#endif
